var capacitorTcpSocket = (function (exports, core) {
    'use strict';

    /**
     * Supported encoding types for data
     */
    exports.DataEncoding = void 0;
    (function (DataEncoding) {
        /**
         * UTF-8 text encoding
         */
        DataEncoding["UTF8"] = "utf8";
        /**
         * Base64 encoded data
         */
        DataEncoding["BASE64"] = "base64";
        /**
         * Hexadecimal string
         */
        DataEncoding["HEX"] = "hex";
    })(exports.DataEncoding || (exports.DataEncoding = {}));

    const TcpSocket = core.registerPlugin('TcpSocket', {
        web: () => Promise.resolve().then(function () { return web; }).then((m) => new m.TcpSocketWeb()),
    });

    /**
     * Web implementation of the TcpSocket plugin.
     *
     * Note: Direct TCP connections are not supported in web browsers due to security restrictions.
     * Consider using WebSockets as an alternative for web applications.
     */
    class TcpSocketWeb extends core.WebPlugin {
        constructor() {
            super(...arguments);
            this.ERROR_MESSAGE = 'TCP sockets are not supported in web browsers.';
        }
        /**
         * Cannot connect directly via TCP from a browser.
         */
        connect(options) {
            console.log('TCP connection attempted in web context:', options);
            return Promise.reject(new Error(this.ERROR_MESSAGE));
        }
        /**
         * Cannot send data via TCP from a browser.
         */
        send(options) {
            console.log('TCP send attempted in web context:', options);
            return Promise.reject(new Error(this.ERROR_MESSAGE));
        }
        /**
         * Cannot read data via TCP from a browser.
         */
        read(options) {
            console.log('TCP read attempted in web context:', options);
            return Promise.reject(new Error(this.ERROR_MESSAGE));
        }
        /**
         * Cannot disconnect TCP socket from a browser.
         */
        disconnect(options) {
            console.log('TCP disconnect attempted in web context:', options);
            return Promise.reject(new Error(this.ERROR_MESSAGE));
        }
    }

    var web = /*#__PURE__*/Object.freeze({
        __proto__: null,
        TcpSocketWeb: TcpSocketWeb
    });

    exports.TcpSocket = TcpSocket;

    return exports;

})({}, capacitorExports);
//# sourceMappingURL=plugin.js.map
