import { WebPlugin } from '@capacitor/core';
/**
 * Web implementation of the TcpSocket plugin.
 *
 * Note: Direct TCP connections are not supported in web browsers due to security restrictions.
 * Consider using WebSockets as an alternative for web applications.
 */
export class TcpSocketWeb extends WebPlugin {
    constructor() {
        super(...arguments);
        this.ERROR_MESSAGE = 'TCP sockets are not supported in web browsers.';
    }
    /**
     * Cannot connect directly via TCP from a browser.
     */
    connect(options) {
        console.log('TCP connection attempted in web context:', options);
        return Promise.reject(new Error(this.ERROR_MESSAGE));
    }
    /**
     * Cannot send data via TCP from a browser.
     */
    send(options) {
        console.log('TCP send attempted in web context:', options);
        return Promise.reject(new Error(this.ERROR_MESSAGE));
    }
    /**
     * Cannot read data via TCP from a browser.
     */
    read(options) {
        console.log('TCP read attempted in web context:', options);
        return Promise.reject(new Error(this.ERROR_MESSAGE));
    }
    /**
     * Cannot disconnect TCP socket from a browser.
     */
    disconnect(options) {
        console.log('TCP disconnect attempted in web context:', options);
        return Promise.reject(new Error(this.ERROR_MESSAGE));
    }
}
//# sourceMappingURL=web.js.map