import { WebPlugin } from '@capacitor/core';
import type { ConnectOptions, ConnectResult, DisconnectOptions, DisconnectResult, ReadOptions, ReadResult, SendOptions, TcpSocketPlugin } from './definitions';
/**
 * Web implementation of the TcpSocket plugin.
 *
 * Note: Direct TCP connections are not supported in web browsers due to security restrictions.
 * Consider using WebSockets as an alternative for web applications.
 */
export declare class TcpSocketWeb extends WebPlugin implements TcpSocketPlugin {
    private readonly ERROR_MESSAGE;
    /**
     * Cannot connect directly via TCP from a browser.
     */
    connect(options: ConnectOptions): Promise<ConnectResult>;
    /**
     * Cannot send data via TCP from a browser.
     */
    send(options: SendOptions): Promise<void>;
    /**
     * Cannot read data via TCP from a browser.
     */
    read(options: ReadOptions): Promise<ReadResult>;
    /**
     * Cannot disconnect TCP socket from a browser.
     */
    disconnect(options: DisconnectOptions): Promise<DisconnectResult>;
}
