import { NgIf } from '@angular/common';
import { Component, ContentChild, ContentChildren, ViewChild } from '@angular/core';
import { IonTabs as IonTabsBase } from '@ionic/angular/common';
import { IonTabBar, IonTab } from '../directives/proxies';
import { IonRouterOutlet } from './router-outlet';
import * as i0 from "@angular/core";
// eslint-disable-next-line @angular-eslint/component-class-suffix
export class IonTabs extends IonTabsBase {
    outlet;
    tabBar;
    tabBars;
    tabs;
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonTabs, deps: null, target: i0.ɵɵFactoryTarget.Component });
    /** @nocollapse */ static ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "16.2.12", type: IonTabs, isStandalone: true, selector: "ion-tabs", queries: [{ propertyName: "tabBar", first: true, predicate: IonTabBar, descendants: true }, { propertyName: "tabBars", predicate: IonTabBar }, { propertyName: "tabs", predicate: IonTab }], viewQueries: [{ propertyName: "outlet", first: true, predicate: ["outlet"], descendants: true, read: IonRouterOutlet }], usesInheritance: true, ngImport: i0, template: `
    <ng-content select="[slot=top]"></ng-content>
    <div class="tabs-inner" #tabsInner>
      <ion-router-outlet
        *ngIf="tabs.length === 0"
        #outlet
        tabs="true"
        (stackWillChange)="onStackWillChange($event)"
        (stackDidChange)="onStackDidChange($event)"
      ></ion-router-outlet>
      <ng-content *ngIf="tabs.length > 0" select="ion-tab"></ng-content>
    </div>
    <ng-content></ng-content>
  `, isInline: true, styles: [":host{display:flex;position:absolute;inset:0;flex-direction:column;width:100%;height:100%;contain:layout size style}.tabs-inner{position:relative;flex:1;contain:layout size style}\n"], dependencies: [{ kind: "component", type: IonRouterOutlet, selector: "ion-router-outlet" }, { kind: "directive", type: NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonTabs, decorators: [{
            type: Component,
            args: [{ selector: 'ion-tabs', template: `
    <ng-content select="[slot=top]"></ng-content>
    <div class="tabs-inner" #tabsInner>
      <ion-router-outlet
        *ngIf="tabs.length === 0"
        #outlet
        tabs="true"
        (stackWillChange)="onStackWillChange($event)"
        (stackDidChange)="onStackDidChange($event)"
      ></ion-router-outlet>
      <ng-content *ngIf="tabs.length > 0" select="ion-tab"></ng-content>
    </div>
    <ng-content></ng-content>
  `, standalone: true, imports: [IonRouterOutlet, NgIf], styles: [":host{display:flex;position:absolute;inset:0;flex-direction:column;width:100%;height:100%;contain:layout size style}.tabs-inner{position:relative;flex:1;contain:layout size style}\n"] }]
        }], propDecorators: { outlet: [{
                type: ViewChild,
                args: ['outlet', { read: IonRouterOutlet, static: false }]
            }], tabBar: [{
                type: ContentChild,
                args: [IonTabBar, { static: false }]
            }], tabBars: [{
                type: ContentChildren,
                args: [IonTabBar]
            }], tabs: [{
                type: ContentChildren,
                args: [IonTab]
            }] } });
//# sourceMappingURL=data:application/json;base64,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