import { __decorate } from "tslib";
import { ChangeDetectionStrategy, Component, HostListener, forwardRef, } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { ValueAccessor } from '@ionic/angular/common';
import { defineCustomElement } from '@ionic/core/components/ion-datetime.js';
import { ProxyCmp, proxyOutputs } from './angular-component-lib/utils';
import * as i0 from "@angular/core";
const DATETIME_INPUTS = [
    'cancelText',
    'clearText',
    'color',
    'dayValues',
    'disabled',
    'doneText',
    'firstDayOfWeek',
    'formatOptions',
    'highlightedDates',
    'hourCycle',
    'hourValues',
    'isDateEnabled',
    'locale',
    'max',
    'min',
    'minuteValues',
    'mode',
    'monthValues',
    'multiple',
    'name',
    'preferWheel',
    'presentation',
    'readonly',
    'showAdjacentDays',
    'showClearButton',
    'showDefaultButtons',
    'showDefaultTimeLabel',
    'showDefaultTitle',
    'size',
    'titleSelectedDatesFormatter',
    'value',
    'yearValues',
];
/**
 * Pulling the provider into an object and using PURE works
 * around an ng-packagr issue that causes
 * components with multiple decorators and
 * a provider to be re-assigned. This re-assignment
 * is not supported by Webpack and causes treeshaking
 * to not work on these kinds of components.

 */
const accessorProvider = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: /*@__PURE__*/ forwardRef(() => IonDatetime),
    multi: true,
};
let IonDatetime = class IonDatetime extends ValueAccessor {
    z;
    el;
    constructor(c, r, z, injector) {
        super(injector, r);
        this.z = z;
        c.detach();
        this.el = r.nativeElement;
        proxyOutputs(this, this.el, ['ionCancel', 'ionChange', 'ionFocus', 'ionBlur']);
    }
    handleIonChange(el) {
        this.handleValueChange(el, el.value);
    }
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonDatetime, deps: [{ token: i0.ChangeDetectorRef }, { token: i0.ElementRef }, { token: i0.NgZone }, { token: i0.Injector }], target: i0.ɵɵFactoryTarget.Component });
    /** @nocollapse */ static ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "16.2.12", type: IonDatetime, isStandalone: true, selector: "ion-datetime", inputs: { cancelText: "cancelText", clearText: "clearText", color: "color", dayValues: "dayValues", disabled: "disabled", doneText: "doneText", firstDayOfWeek: "firstDayOfWeek", formatOptions: "formatOptions", highlightedDates: "highlightedDates", hourCycle: "hourCycle", hourValues: "hourValues", isDateEnabled: "isDateEnabled", locale: "locale", max: "max", min: "min", minuteValues: "minuteValues", mode: "mode", monthValues: "monthValues", multiple: "multiple", name: "name", preferWheel: "preferWheel", presentation: "presentation", readonly: "readonly", showAdjacentDays: "showAdjacentDays", showClearButton: "showClearButton", showDefaultButtons: "showDefaultButtons", showDefaultTimeLabel: "showDefaultTimeLabel", showDefaultTitle: "showDefaultTitle", size: "size", titleSelectedDatesFormatter: "titleSelectedDatesFormatter", value: "value", yearValues: "yearValues" }, host: { listeners: { "ionChange": "handleIonChange($event.target)" } }, providers: [accessorProvider], usesInheritance: true, ngImport: i0, template: '<ng-content></ng-content>', isInline: true, changeDetection: i0.ChangeDetectionStrategy.OnPush });
};
IonDatetime = __decorate([
    ProxyCmp({
        defineCustomElementFn: defineCustomElement,
        inputs: DATETIME_INPUTS,
        methods: ['confirm', 'reset', 'cancel'],
    })
], IonDatetime);
export { IonDatetime };
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: IonDatetime, decorators: [{
            type: Component,
            args: [{
                    selector: 'ion-datetime',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    template: '<ng-content></ng-content>',
                    // eslint-disable-next-line @angular-eslint/no-inputs-metadata-property
                    inputs: DATETIME_INPUTS,
                    providers: [accessorProvider],
                    standalone: true,
                }]
        }], ctorParameters: function () { return [{ type: i0.ChangeDetectorRef }, { type: i0.ElementRef }, { type: i0.NgZone }, { type: i0.Injector }]; }, propDecorators: { handleIonChange: [{
                type: HostListener,
                args: ['ionChange', ['$event.target']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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