import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
export class DomController {
    /**
     * Schedules a task to run during the READ phase of the next frame.
     * This task should only read the DOM, but never modify it.
     */
    read(cb) {
        getQueue().read(cb);
    }
    /**
     * Schedules a task to run during the WRITE phase of the next frame.
     * This task should write the DOM, but never READ it.
     */
    write(cb) {
        getQueue().write(cb);
    }
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: DomController, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
    /** @nocollapse */ static ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: DomController, providedIn: 'root' });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: DomController, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }] });
const getQueue = () => {
    const win = typeof window !== 'undefined' ? window : null;
    if (win != null) {
        const Ionic = win.Ionic;
        if (Ionic?.queue) {
            return Ionic.queue;
        }
        return {
            read: (cb) => win.requestAnimationFrame(cb),
            write: (cb) => win.requestAnimationFrame(cb),
        };
    }
    return {
        read: (cb) => cb(),
        write: (cb) => cb(),
    };
};
//# sourceMappingURL=data:application/json;base64,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