export const insertView = (views, view, direction) => {
    if (direction === 'root') {
        return setRoot(views, view);
    }
    else if (direction === 'forward') {
        return setForward(views, view);
    }
    else {
        return setBack(views, view);
    }
};
const setRoot = (views, view) => {
    views = views.filter((v) => v.stackId !== view.stackId);
    views.push(view);
    return views;
};
const setForward = (views, view) => {
    const index = views.indexOf(view);
    if (index >= 0) {
        views = views.filter((v) => v.stackId !== view.stackId || v.id <= view.id);
    }
    else {
        views.push(view);
    }
    return views;
};
const setBack = (views, view) => {
    const index = views.indexOf(view);
    if (index >= 0) {
        return views.filter((v) => v.stackId !== view.stackId || v.id <= view.id);
    }
    else {
        return setRoot(views, view);
    }
};
export const getUrl = (router, activatedRoute) => {
    const urlTree = router.createUrlTree(['.'], { relativeTo: activatedRoute });
    return router.serializeUrl(urlTree);
};
export const isTabSwitch = (enteringView, leavingView) => {
    if (!leavingView) {
        return true;
    }
    return enteringView.stackId !== leavingView.stackId;
};
export const computeStackId = (prefixUrl, url) => {
    if (!prefixUrl) {
        return undefined;
    }
    const segments = toSegments(url);
    for (let i = 0; i < segments.length; i++) {
        if (i >= prefixUrl.length) {
            return segments[i];
        }
        if (segments[i] !== prefixUrl[i]) {
            return undefined;
        }
    }
    return undefined;
};
export const toSegments = (path) => {
    return path
        .split('/')
        .map((s) => s.trim())
        .filter((s) => s !== '');
};
export const destroyView = (view) => {
    if (view) {
        view.ref.destroy();
        view.unlistenEvents();
    }
};
//# sourceMappingURL=data:application/json;base64,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