import { Directive, HostListener, Input, Optional } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "../../providers/nav-controller";
import * as i3 from "@angular/router";
/**
 * Adds support for Ionic routing directions and animations to the base Angular router link directive.
 *
 * When the router link is clicked, the directive will assign the direction and
 * animation so that the routing integration will transition correctly.
 */
export class RouterLinkDelegateDirective {
    locationStrategy;
    navCtrl;
    elementRef;
    router;
    routerLink;
    routerDirection = 'forward';
    routerAnimation;
    constructor(locationStrategy, navCtrl, elementRef, router, routerLink) {
        this.locationStrategy = locationStrategy;
        this.navCtrl = navCtrl;
        this.elementRef = elementRef;
        this.router = router;
        this.routerLink = routerLink;
    }
    ngOnInit() {
        this.updateTargetUrlAndHref();
        this.updateTabindex();
    }
    ngOnChanges() {
        this.updateTargetUrlAndHref();
    }
    /**
     * The `tabindex` is set to `0` by default on the host element when
     * the `routerLink` directive is used. This causes issues with Ionic
     * components that wrap an `a` or `button` element, such as `ion-item`.
     * See issue https://github.com/angular/angular/issues/28345
     *
     * This method removes the `tabindex` attribute from the host element
     * to allow the Ionic component to manage the focus state correctly.
     */
    updateTabindex() {
        // Ionic components that render a native anchor or button element
        const ionicComponents = [
            'ION-BACK-BUTTON',
            'ION-BREADCRUMB',
            'ION-BUTTON',
            'ION-CARD',
            'ION-FAB-BUTTON',
            'ION-ITEM',
            'ION-ITEM-OPTION',
            'ION-MENU-BUTTON',
            'ION-SEGMENT-BUTTON',
            'ION-TAB-BUTTON',
        ];
        const hostElement = this.elementRef.nativeElement;
        if (ionicComponents.includes(hostElement.tagName)) {
            if (hostElement.getAttribute('tabindex') === '0') {
                hostElement.removeAttribute('tabindex');
            }
        }
    }
    updateTargetUrlAndHref() {
        if (this.routerLink?.urlTree) {
            const href = this.locationStrategy.prepareExternalUrl(this.router.serializeUrl(this.routerLink.urlTree));
            this.elementRef.nativeElement.href = href;
        }
    }
    /**
     * @internal
     */
    onClick(ev) {
        this.navCtrl.setDirection(this.routerDirection, undefined, undefined, this.routerAnimation);
        /**
         * This prevents the browser from
         * performing a page reload when pressing
         * an Ionic component with routerLink.
         * The page reload interferes with routing
         * and causes ion-back-button to disappear
         * since the local history is wiped on reload.
         */
        ev.preventDefault();
    }
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: RouterLinkDelegateDirective, deps: [{ token: i1.LocationStrategy }, { token: i2.NavController }, { token: i0.ElementRef }, { token: i3.Router }, { token: i3.RouterLink, optional: true }], target: i0.ɵɵFactoryTarget.Directive });
    /** @nocollapse */ static ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "16.2.12", type: RouterLinkDelegateDirective, selector: ":not(a):not(area)[routerLink]", inputs: { routerDirection: "routerDirection", routerAnimation: "routerAnimation" }, host: { listeners: { "click": "onClick($event)" } }, usesOnChanges: true, ngImport: i0 });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: RouterLinkDelegateDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: ':not(a):not(area)[routerLink]',
                }]
        }], ctorParameters: function () { return [{ type: i1.LocationStrategy }, { type: i2.NavController }, { type: i0.ElementRef }, { type: i3.Router }, { type: i3.RouterLink, decorators: [{
                    type: Optional
                }] }]; }, propDecorators: { routerDirection: [{
                type: Input
            }], routerAnimation: [{
                type: Input
            }], onClick: [{
                type: HostListener,
                args: ['click', ['$event']]
            }] } });
export class RouterLinkWithHrefDelegateDirective {
    locationStrategy;
    navCtrl;
    elementRef;
    router;
    routerLink;
    routerDirection = 'forward';
    routerAnimation;
    constructor(locationStrategy, navCtrl, elementRef, router, routerLink) {
        this.locationStrategy = locationStrategy;
        this.navCtrl = navCtrl;
        this.elementRef = elementRef;
        this.router = router;
        this.routerLink = routerLink;
    }
    ngOnInit() {
        this.updateTargetUrlAndHref();
    }
    ngOnChanges() {
        this.updateTargetUrlAndHref();
    }
    updateTargetUrlAndHref() {
        if (this.routerLink?.urlTree) {
            const href = this.locationStrategy.prepareExternalUrl(this.router.serializeUrl(this.routerLink.urlTree));
            this.elementRef.nativeElement.href = href;
        }
    }
    /**
     * @internal
     */
    onClick() {
        this.navCtrl.setDirection(this.routerDirection, undefined, undefined, this.routerAnimation);
    }
    /** @nocollapse */ static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: RouterLinkWithHrefDelegateDirective, deps: [{ token: i1.LocationStrategy }, { token: i2.NavController }, { token: i0.ElementRef }, { token: i3.Router }, { token: i3.RouterLink, optional: true }], target: i0.ɵɵFactoryTarget.Directive });
    /** @nocollapse */ static ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "16.2.12", type: RouterLinkWithHrefDelegateDirective, selector: "a[routerLink],area[routerLink]", inputs: { routerDirection: "routerDirection", routerAnimation: "routerAnimation" }, host: { listeners: { "click": "onClick()" } }, usesOnChanges: true, ngImport: i0 });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.12", ngImport: i0, type: RouterLinkWithHrefDelegateDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: 'a[routerLink],area[routerLink]',
                }]
        }], ctorParameters: function () { return [{ type: i1.LocationStrategy }, { type: i2.NavController }, { type: i0.ElementRef }, { type: i3.Router }, { type: i3.RouterLink, decorators: [{
                    type: Optional
                }] }]; }, propDecorators: { routerDirection: [{
                type: Input
            }], routerAnimation: [{
                type: Input
            }], onClick: [{
                type: HostListener,
                args: ['click']
            }] } });
//# sourceMappingURL=data:application/json;base64,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