declare const _default: {
    configs: {
        all: {
            parser: string;
            plugins: string[];
            rules: {
                "@angular-eslint/component-class-suffix": string;
                "@angular-eslint/component-max-inline-declarations": string;
                "@angular-eslint/component-selector": string;
                "@angular-eslint/consistent-component-styles": string;
                "@angular-eslint/contextual-decorator": string;
                "@angular-eslint/contextual-lifecycle": string;
                "@angular-eslint/directive-class-suffix": string;
                "@angular-eslint/directive-selector": string;
                "@angular-eslint/no-async-lifecycle-method": string;
                "@angular-eslint/no-attribute-decorator": string;
                "@angular-eslint/no-conflicting-lifecycle": string;
                "@angular-eslint/no-developer-preview": string;
                "@angular-eslint/no-duplicates-in-metadata-arrays": string;
                "@angular-eslint/no-empty-lifecycle-method": string;
                "@angular-eslint/no-experimental": string;
                "@angular-eslint/no-forward-ref": string;
                "@angular-eslint/no-input-prefix": string;
                "@angular-eslint/no-input-rename": string;
                "@angular-eslint/no-inputs-metadata-property": string;
                "@angular-eslint/no-lifecycle-call": string;
                "@angular-eslint/no-output-native": string;
                "@angular-eslint/no-output-on-prefix": string;
                "@angular-eslint/no-output-rename": string;
                "@angular-eslint/no-outputs-metadata-property": string;
                "@angular-eslint/no-pipe-impure": string;
                "@angular-eslint/no-queries-metadata-property": string;
                "@angular-eslint/no-uncalled-signals": string;
                "@angular-eslint/pipe-prefix": string;
                "@angular-eslint/prefer-inject": string;
                "@angular-eslint/prefer-on-push-component-change-detection": string;
                "@angular-eslint/prefer-output-emitter-ref": string;
                "@angular-eslint/prefer-output-readonly": string;
                "@angular-eslint/prefer-signals": string;
                "@angular-eslint/prefer-standalone": string;
                "@angular-eslint/relative-url-prefix": string;
                "@angular-eslint/require-lifecycle-on-prototype": string;
                "@angular-eslint/require-localize-metadata": string;
                "@angular-eslint/runtime-localize": string;
                "@angular-eslint/sort-keys-in-type-decorator": string;
                "@angular-eslint/sort-lifecycle-methods": string;
                "@angular-eslint/use-component-selector": string;
                "@angular-eslint/use-component-view-encapsulation": string;
                "@angular-eslint/use-injectable-provided-in": string;
                "@angular-eslint/use-lifecycle-interface": string;
                "@angular-eslint/use-pipe-transform-interface": string;
            };
        };
        recommended: {
            parser: string;
            plugins: string[];
            rules: {
                "@angular-eslint/contextual-lifecycle": string;
                "@angular-eslint/no-empty-lifecycle-method": string;
                "@angular-eslint/no-input-rename": string;
                "@angular-eslint/no-inputs-metadata-property": string;
                "@angular-eslint/no-output-native": string;
                "@angular-eslint/no-output-on-prefix": string;
                "@angular-eslint/no-output-rename": string;
                "@angular-eslint/no-outputs-metadata-property": string;
                "@angular-eslint/prefer-inject": string;
                "@angular-eslint/prefer-standalone": string;
                "@angular-eslint/use-pipe-transform-interface": string;
                "@angular-eslint/use-lifecycle-interface": string;
            };
        };
    };
    rules: {
        "component-class-suffix": import("@typescript-eslint/utils/ts-eslint").RuleModule<"componentClassSuffix", import("./rules/component-class-suffix").Options, import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "component-max-inline-declarations": import("@typescript-eslint/utils/ts-eslint").RuleModule<"componentMaxInlineDeclarations", import("./rules/component-max-inline-declarations").Options, import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "component-selector": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/component-selector").MessageIds, import("@angular-eslint/utils/dist/eslint-plugin/selector-utils").Options, import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "consistent-component-styles": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/consistent-component-styles").MessageIds, import("./rules/consistent-component-styles").Options, import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "contextual-decorator": import("@typescript-eslint/utils/ts-eslint").RuleModule<"contextualDecorator", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "contextual-lifecycle": import("@typescript-eslint/utils/ts-eslint").RuleModule<"contextualLifecycle", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "directive-class-suffix": import("@typescript-eslint/utils/ts-eslint").RuleModule<"directiveClassSuffix", import("./rules/directive-class-suffix").Options, import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "directive-selector": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/directive-selector").MessageIds, import("@angular-eslint/utils/dist/eslint-plugin/selector-utils").Options, import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-async-lifecycle-method": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noAsyncLifecycleMethod", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-attribute-decorator": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noAttributeDecorator", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-conflicting-lifecycle": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/no-conflicting-lifecycle").MessageIds, [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-duplicates-in-metadata-arrays": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noDuplicatesInMetadataArrays", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-empty-lifecycle-method": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/no-empty-lifecycle-method").MessageIds, [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-forward-ref": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noForwardRef", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-input-prefix": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noInputPrefix", import("./rules/no-input-prefix").Options, import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-input-rename": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/no-input-rename").MessageIds, import("./rules/no-input-rename").Options, import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-inputs-metadata-property": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noInputsMetadataProperty", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-lifecycle-call": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noLifecycleCall", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-uncalled-signals": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/no-uncalled-signals").MessageIds, [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-output-native": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noOutputNative", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-output-on-prefix": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noOutputOnPrefix", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-output-rename": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/no-output-rename").MessageIds, [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-outputs-metadata-property": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noOutputsMetadataProperty", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-pipe-impure": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/no-pipe-impure").MessageIds, [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-queries-metadata-property": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noQueriesMetadataProperty", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "pipe-prefix": import("@typescript-eslint/utils/ts-eslint").RuleModule<"pipePrefix", import("./rules/pipe-prefix").Options, import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "prefer-on-push-component-change-detection": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/prefer-on-push-component-change-detection").MessageIds, [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "prefer-signals": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/prefer-signals").MessageIds, [{
            preferReadonlySignalProperties: boolean;
            preferInputSignals: boolean;
            preferQuerySignals: boolean;
            useTypeChecking: boolean;
            additionalSignalCreationFunctions: string[];
        }], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "prefer-standalone": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/prefer-standalone").MessageIds, [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "prefer-inject": import("@typescript-eslint/utils/ts-eslint").RuleModule<"preferInject", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "prefer-output-emitter-ref": import("@typescript-eslint/utils/ts-eslint").RuleModule<"preferOutputEmitterRef", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "prefer-output-readonly": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/prefer-output-readonly").MessageIds, [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "relative-url-prefix": import("@typescript-eslint/utils/ts-eslint").RuleModule<"relativeUrlPrefix", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "require-lifecycle-on-prototype": import("@typescript-eslint/utils/ts-eslint").RuleModule<"defineOnPrototype", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "require-localize-metadata": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/require-localize-metadata").MessageIds, import("./rules/require-localize-metadata").Options, import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "runtime-localize": import("@typescript-eslint/utils/ts-eslint").RuleModule<"runtimeLocalize", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "sort-keys-in-type-decorator": import("@typescript-eslint/utils/ts-eslint").RuleModule<"incorrectOrder", import("./rules/sort-keys-in-type-decorator").Options, import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "sort-lifecycle-methods": import("@typescript-eslint/utils/ts-eslint").RuleModule<"lifecycleMethodsNotSorted", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "use-component-selector": import("@typescript-eslint/utils/ts-eslint").RuleModule<"useComponentSelector", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "use-component-view-encapsulation": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/use-component-view-encapsulation").MessageIds, [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "use-injectable-provided-in": import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./rules/use-injectable-provided-in").MessageIds, import("./rules/use-injectable-provided-in").Options, import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "use-lifecycle-interface": import("@typescript-eslint/utils/ts-eslint").RuleModule<"useLifecycleInterface", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "use-pipe-transform-interface": import("@typescript-eslint/utils/ts-eslint").RuleModule<"usePipeTransformInterface", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-experimental": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noExperimental", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-developer-preview": import("@typescript-eslint/utils/ts-eslint").RuleModule<"noDeveloperPreview", [], import("./utils/create-eslint-rule").RuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
    };
};
export = _default;
//# sourceMappingURL=index.d.ts.map