"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getInteractiveElementAXObjectSchemas = getInteractiveElementAXObjectSchemas;
let interactiveElementAXObjectSchemas = null;
// This function follows the lazy initialization pattern.
// Since this is a top-level module (it will be included via `require`), we do not need to
// initialize the `interactiveElementAXObjectSchemas` until the function is called
// for the first time, so we will not take up the memory.
function getInteractiveElementAXObjectSchemas() {
    if (interactiveElementAXObjectSchemas === null) {
        // This package doesn't have type definitions.
        const { AXObjects, elementAXObjects } = require('axobject-query');
        // This set will contain all possible roles in ARIA, which are
        // type of `structure` or `window` (since we filter out `widget` type).
        const interactiveAXObjects = new Set(Array.from(AXObjects.keys()).filter((name) => AXObjects.get(name).type === 'widget'));
        // This will contain all schemas that are related to ARIA roles
        // listed in the above set `interactiveAXObjects`.
        interactiveElementAXObjectSchemas = [...elementAXObjects.entries()].reduce((accumulator, [elementSchema, AXObjectSet]) => {
            return accumulator.concat([...AXObjectSet].every((role) => interactiveAXObjects.has(role))
                ? // summary element should not have required attributes
                    elementSchema.name === 'summary'
                        ? { ...elementSchema, attributes: [] }
                        : elementSchema
                : []);
        }, []);
    }
    return interactiveElementAXObjectSchemas;
}
