/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.statusbar;

import android.content.res.Configuration;
import com.capacitorjs.plugins.statusbar.StatusBar;
import com.capacitorjs.plugins.statusbar.StatusBarConfig;
import com.capacitorjs.plugins.statusbar.StatusBarInfo;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.CapacitorPlugin;
import com.getcapacitor.util.WebColor;
import java.util.Locale;

@CapacitorPlugin(name="StatusBar")
public class StatusBarPlugin
extends Plugin {
    private StatusBar implementation;

    public void load() {
        StatusBarConfig config = this.getStatusBarConfig();
        this.implementation = new StatusBar(this.getActivity(), config, (eventName, info) -> this.notifyListeners(eventName, this.toJSObject(info), true));
    }

    private StatusBarConfig getStatusBarConfig() {
        StatusBarConfig config = new StatusBarConfig();
        String backgroundColor = this.getConfig().getString("backgroundColor");
        if (backgroundColor != null) {
            try {
                config.setBackgroundColor(WebColor.parseColor((String)backgroundColor));
            }
            catch (IllegalArgumentException ex) {
                Logger.debug((String)"Background color not applied");
            }
        }
        config.setStyle(this.styleFromConfig(this.getConfig().getString("style", config.getStyle())));
        config.setOverlaysWebView(this.getConfig().getBoolean("overlaysWebView", config.isOverlaysWebView()));
        return config;
    }

    private String styleFromConfig(String style) {
        switch (style.toLowerCase()) {
            case "lightcontent": 
            case "dark": {
                return "DARK";
            }
            case "darkcontent": 
            case "light": {
                return "LIGHT";
            }
        }
        return "DEFAULT";
    }

    protected void handleOnConfigurationChanged(Configuration newConfig) {
        super.handleOnConfigurationChanged(newConfig);
        this.implementation.updateStyle();
    }

    @PluginMethod
    public void setStyle(PluginCall call) {
        String style = call.getString("style");
        if (style == null) {
            call.reject("Style must be provided");
            return;
        }
        this.getBridge().executeOnMainThread(() -> {
            this.implementation.setStyle(style);
            call.resolve();
        });
    }

    @PluginMethod
    public void setBackgroundColor(PluginCall call) {
        String color = call.getString("color");
        if (color == null) {
            call.reject("Color must be provided");
            return;
        }
        this.getBridge().executeOnMainThread(() -> {
            try {
                int parsedColor = WebColor.parseColor((String)color.toUpperCase(Locale.ROOT));
                this.implementation.setBackgroundColor(parsedColor);
                call.resolve();
            }
            catch (IllegalArgumentException ex) {
                call.reject("Invalid color provided. Must be a hex string (ex: #ff0000");
            }
        });
    }

    @PluginMethod
    public void hide(PluginCall call) {
        this.getBridge().executeOnMainThread(() -> {
            this.implementation.hide();
            call.resolve();
        });
    }

    @PluginMethod
    public void show(PluginCall call) {
        this.getBridge().executeOnMainThread(() -> {
            this.implementation.show();
            call.resolve();
        });
    }

    @PluginMethod
    public void getInfo(PluginCall call) {
        StatusBarInfo info = this.implementation.getInfo();
        call.resolve(this.toJSObject(info));
    }

    @PluginMethod
    public void setOverlaysWebView(PluginCall call) {
        Boolean overlay = call.getBoolean("overlay", Boolean.valueOf(true));
        this.getBridge().executeOnMainThread(() -> {
            this.implementation.setOverlaysWebView(overlay);
            call.resolve();
        });
    }

    private JSObject toJSObject(StatusBarInfo info) {
        JSObject data = new JSObject();
        data.put("visible", info.isVisible());
        data.put("style", info.getStyle());
        data.put("color", info.getColor());
        data.put("overlays", info.isOverlays());
        data.put("height", info.getHeight());
        return data;
    }
}

