/*
 * Decompiled with CFR 0.152.
 */
package com.svend.plugins.tcp.socket;

import android.util.Base64;
import android.util.Log;
import com.getcapacitor.JSObject;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.CapacitorPlugin;
import com.getcapacitor.annotation.Permission;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

@CapacitorPlugin(name="TcpSocket", permissions={@Permission(alias="network", strings={"android.permission.ACCESS_NETWORK_STATE"})})
public class TcpSocketPlugin
extends Plugin {
    private static final String TAG = "TcpSocketPlugin";
    private List<Socket> clients = new ArrayList<Socket>();

    @PluginMethod
    public void connect(PluginCall call) {
        String ipAddress = call.getString("ipAddress");
        if (ipAddress == null || ipAddress.isEmpty()) {
            call.reject("IP address is required");
            return;
        }
        Integer port = call.getInt("port", Integer.valueOf(9100));
        try {
            Socket socket = new Socket(ipAddress, (int)port);
            this.clients.add(socket);
            JSObject ret = new JSObject();
            ret.put("client", this.clients.size() - 1);
            call.resolve(ret);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Connection failed: " + e.getMessage()));
            call.reject("Connection failed: " + e.getMessage());
        }
    }

    @PluginMethod
    public void send(final PluginCall call) {
        final Integer clientIndex = call.getInt("client", Integer.valueOf(-1));
        if (clientIndex == -1) {
            call.reject("Client not specified or invalid index");
            return;
        }
        if (clientIndex >= this.clients.size() || clientIndex < 0) {
            call.reject("Client index out of range");
            return;
        }
        final String data = call.getString("data");
        if (data == null || data.isEmpty()) {
            call.reject("No data provided");
            return;
        }
        final String encodingString = call.getString("encoding", "utf8");
        final DataEncoding encoding = DataEncoding.fromString(encodingString);
        Socket socket = this.clients.get(clientIndex);
        if (!socket.isConnected()) {
            this.closeSocketSafely(socket);
            call.reject("Socket not connected");
            return;
        }
        Runnable runnable = new Runnable(){
            final /* synthetic */ TcpSocketPlugin this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    Socket socket = this.this$0.clients.get(clientIndex);
                    DataOutputStream bufferOut = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
                    byte[] bytes = switch (encoding.ordinal()) {
                        case 1 -> Base64.decode((String)data, (int)0);
                        case 2 -> this.this$0.hexStringToBytes(data);
                        default -> data.getBytes(StandardCharsets.UTF_8);
                    };
                    if (bytes != null) {
                        bufferOut.write(bytes);
                        bufferOut.flush();
                        call.resolve();
                    } else {
                        call.reject("Failed to decode data with encoding: " + encodingString);
                    }
                }
                catch (IOException e) {
                    Log.e((String)TcpSocketPlugin.TAG, (String)("Send failed: " + e.getMessage()));
                    call.reject("Send failed: " + e.getMessage());
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    @PluginMethod
    public void read(final PluginCall call) {
        final Integer clientIndex = call.getInt("client", Integer.valueOf(-1));
        final Integer length = call.getInt("expectLen", Integer.valueOf(1024));
        if (clientIndex == -1) {
            call.reject("Client not specified or invalid index");
            return;
        }
        if (clientIndex >= this.clients.size() || clientIndex < 0) {
            call.reject("Client index out of range");
            return;
        }
        Socket socket = this.clients.get(clientIndex);
        if (!socket.isConnected()) {
            this.closeSocketSafely(socket);
            call.reject("Socket not connected");
            return;
        }
        String encodingString = call.getString("encoding", "utf8");
        final DataEncoding encoding = DataEncoding.fromString(encodingString);
        Runnable runnable = new Runnable(){
            final /* synthetic */ TcpSocketPlugin this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    Socket socket = this.this$0.clients.get(clientIndex);
                    DataInputStream bufferIn = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
                    byte[] bytes = new byte[length.intValue()];
                    int read = bufferIn.read(bytes, 0, length);
                    JSObject ret = new JSObject();
                    String result = "";
                    String actualEncoding = encoding.getValue();
                    if (read > 0) {
                        byte[] actualData = new byte[read];
                        System.arraycopy(bytes, 0, actualData, 0, read);
                        switch (encoding.ordinal()) {
                            case 0: {
                                try {
                                    result = new String(actualData, StandardCharsets.UTF_8);
                                }
                                catch (Exception e) {
                                    result = Base64.encodeToString((byte[])actualData, (int)2);
                                    actualEncoding = DataEncoding.BASE64.getValue();
                                }
                                break;
                            }
                            case 1: {
                                result = Base64.encodeToString((byte[])actualData, (int)2);
                                break;
                            }
                            case 2: {
                                result = this.this$0.bytesToHexString(actualData);
                            }
                        }
                    }
                    ret.put("result", result);
                    ret.put("encoding", actualEncoding);
                    call.resolve(ret);
                }
                catch (IOException e) {
                    Log.e((String)TcpSocketPlugin.TAG, (String)("Read failed: " + e.getMessage()));
                    call.reject("Read failed: " + e.getMessage());
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    @PluginMethod
    public void disconnect(PluginCall call) {
        Integer clientIndex = call.getInt("client", Integer.valueOf(-1));
        if (clientIndex == -1) {
            call.reject("Client not specified or invalid index");
            return;
        }
        if (this.clients.isEmpty()) {
            call.reject("No active connections");
            return;
        }
        if (clientIndex >= this.clients.size() || clientIndex < 0) {
            call.reject("Client index out of range");
            return;
        }
        Socket socket = this.clients.get(clientIndex);
        try {
            if (!socket.isConnected()) {
                socket.close();
                call.reject("Socket not connected");
                return;
            }
            socket.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Disconnect failed: " + e.getMessage()));
            call.reject("Disconnect failed: " + e.getMessage());
            return;
        }
        JSObject ret = new JSObject();
        ret.put("client", (Object)clientIndex);
        call.resolve(ret);
    }

    private void closeSocketSafely(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Error closing socket: " + e.getMessage()));
            }
        }
    }

    protected void handleOnDestroy() {
        for (Socket socket : this.clients) {
            this.closeSocketSafely(socket);
        }
        this.clients.clear();
        super.handleOnDestroy();
    }

    private byte[] hexStringToBytes(String hex) {
        String cleanHex = hex.replace("0x", "").replace(" ", "").replace("\n", "");
        if (cleanHex.length() % 2 != 0) {
            return null;
        }
        byte[] data = new byte[cleanHex.length() / 2];
        try {
            for (int i = 0; i < cleanHex.length(); i += 2) {
                data[i / 2] = (byte)Integer.parseInt(cleanHex.substring(i, i + 2), 16);
            }
            return data;
        }
        catch (NumberFormatException e) {
            Log.e((String)TAG, (String)("Invalid hex string: " + e.getMessage()));
            return null;
        }
    }

    private String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static enum DataEncoding {
        UTF8("utf8"),
        BASE64("base64"),
        HEX("hex");

        private final String value;

        private DataEncoding(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static DataEncoding fromString(String text) {
            for (DataEncoding encoding : DataEncoding.values()) {
                if (!encoding.value.equalsIgnoreCase(text)) continue;
                return encoding;
            }
            return UTF8;
        }
    }
}

