/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor.plugin.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.StrictMode;
import androidx.core.content.FileProvider;
import com.getcapacitor.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;

public final class AssetUtil {
    public static final int RESOURCE_ID_ZERO_VALUE = 0;
    private static final String STORAGE_FOLDER = "/capacitorassets";
    private final Context context;

    private AssetUtil(Context context) {
        this.context = context;
    }

    public static AssetUtil getInstance(Context context) {
        return new AssetUtil(context);
    }

    public Uri parse(String path) {
        if (path == null || path.isEmpty()) {
            return Uri.EMPTY;
        }
        if (path.startsWith("res:")) {
            return this.getUriForResourcePath(path);
        }
        if (path.startsWith("file:///")) {
            return this.getUriFromPath(path);
        }
        if (path.startsWith("file://")) {
            return this.getUriFromAsset(path);
        }
        if (path.startsWith("http")) {
            return this.getUriFromRemote(path);
        }
        if (path.startsWith("content://")) {
            return Uri.parse((String)path);
        }
        return Uri.EMPTY;
    }

    private Uri getUriFromPath(String path) {
        String absPath = path.replaceFirst("file://", "").replaceFirst("\\?.*$", "");
        File file = new File(absPath);
        if (!file.exists()) {
            Logger.error("File not found: " + file.getAbsolutePath());
            return Uri.EMPTY;
        }
        return this.getUriFromFile(file);
    }

    private Uri getUriFromAsset(String path) {
        String resPath = path.replaceFirst("file:/", "www").replaceFirst("\\?.*$", "");
        String fileName = resPath.substring(resPath.lastIndexOf(47) + 1);
        File file = this.getTmpFile(fileName);
        if (file == null) {
            return Uri.EMPTY;
        }
        try {
            AssetManager assets = this.context.getAssets();
            InputStream in = assets.open(resPath);
            FileOutputStream out = new FileOutputStream(file);
            this.copyFile(in, out);
        }
        catch (Exception e) {
            Logger.error("File not found: assets/" + resPath);
            return Uri.EMPTY;
        }
        return this.getUriFromFile(file);
    }

    private Uri getUriForResourcePath(String path) {
        Resources res = this.context.getResources();
        String resPath = path.replaceFirst("res://", "");
        int resId = this.getResId(resPath);
        if (resId == 0) {
            Logger.error("File not found: " + resPath);
            return Uri.EMPTY;
        }
        return new Uri.Builder().scheme("android.resource").authority(res.getResourcePackageName(resId)).appendPath(res.getResourceTypeName(resId)).appendPath(res.getResourceEntryName(resId)).build();
    }

    private Uri getUriFromRemote(String path) {
        File file = this.getTmpFile();
        if (file == null) {
            return Uri.EMPTY;
        }
        try {
            URL url = new URL(path);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
            connection.setRequestProperty("Connection", "close");
            connection.setConnectTimeout(5000);
            connection.connect();
            InputStream in = connection.getInputStream();
            FileOutputStream out = new FileOutputStream(file);
            this.copyFile(in, out);
            return this.getUriFromFile(file);
        }
        catch (MalformedURLException e) {
            Logger.error(Logger.tags("Asset"), "Incorrect URL", e);
        }
        catch (FileNotFoundException e) {
            Logger.error(Logger.tags("Asset"), "Failed to create new File from HTTP Content", e);
        }
        catch (IOException e) {
            Logger.error(Logger.tags("Asset"), "No Input can be created from http Stream", e);
        }
        return Uri.EMPTY;
    }

    private void copyFile(InputStream in, FileOutputStream out) {
        byte[] buffer = new byte[1024];
        try {
            int read;
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            Logger.error("Error copying", e);
        }
    }

    public int getResId(String resPath) {
        int resId = this.getResId(this.context.getResources(), resPath);
        if (resId == 0) {
            resId = this.getResId(Resources.getSystem(), resPath);
        }
        return resId;
    }

    private int getResId(Resources res, String resPath) {
        String pkgName = this.getPkgName(res);
        String resName = this.getBaseName(resPath);
        int resId = res.getIdentifier(resName, "mipmap", pkgName);
        if (resId == 0) {
            resId = res.getIdentifier(resName, "drawable", pkgName);
        }
        if (resId == 0) {
            resId = res.getIdentifier(resName, "raw", pkgName);
        }
        return resId;
    }

    public Bitmap getIconFromUri(Uri uri) throws IOException {
        InputStream input = this.context.getContentResolver().openInputStream(uri);
        return BitmapFactory.decodeStream((InputStream)input);
    }

    private String getBaseName(String resPath) {
        String drawable = resPath;
        if (drawable.contains("/")) {
            drawable = drawable.substring(drawable.lastIndexOf(47) + 1);
        }
        if (resPath.contains(".")) {
            drawable = drawable.substring(0, drawable.lastIndexOf(46));
        }
        return drawable;
    }

    private File getTmpFile() {
        return this.getTmpFile(UUID.randomUUID().toString());
    }

    private File getTmpFile(String name) {
        File dir = this.context.getExternalCacheDir();
        if (dir == null) {
            dir = this.context.getCacheDir();
        }
        if (dir == null) {
            Logger.error(Logger.tags("Asset"), "Missing cache dir", null);
            return null;
        }
        String storage = dir.toString() + STORAGE_FOLDER;
        new File(storage).mkdir();
        return new File(storage, name);
    }

    private Uri getUriFromFile(File file) {
        try {
            String authority = this.context.getPackageName() + ".provider";
            return FileProvider.getUriForFile((Context)this.context, (String)authority, (File)file);
        }
        catch (IllegalArgumentException e) {
            Logger.error("File not supported by provider", e);
            return Uri.EMPTY;
        }
    }

    private String getPkgName(Resources res) {
        return res == Resources.getSystem() ? "android" : this.context.getPackageName();
    }

    public static int getResourceID(Context context, String resourceName, String dir) {
        return context.getResources().getIdentifier(resourceName, dir, context.getPackageName());
    }

    public static String getResourceBaseName(String resPath) {
        if (resPath == null) {
            return null;
        }
        if (resPath.contains("/")) {
            return resPath.substring(resPath.lastIndexOf(47) + 1);
        }
        if (resPath.contains(".")) {
            return resPath.substring(0, resPath.lastIndexOf(46));
        }
        return resPath;
    }
}

