/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import android.content.Context;
import android.net.Uri;
import android.util.Base64;
import android.webkit.CookieManager;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import com.getcapacitor.AndroidProtocolHandler;
import com.getcapacitor.Bridge;
import com.getcapacitor.JSInjector;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import com.getcapacitor.ProcessedRoute;
import com.getcapacitor.RouteProcessor;
import com.getcapacitor.UriMatcher;
import com.getcapacitor.plugin.util.CapacitorHttpUrlConnection;
import com.getcapacitor.plugin.util.HttpRequestHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WebViewLocalServer {
    private static final String capacitorFileStart = "/_capacitor_file_";
    private static final String capacitorContentStart = "/_capacitor_content_";
    private String basePath;
    private final UriMatcher uriMatcher = new UriMatcher(null);
    private final AndroidProtocolHandler protocolHandler;
    private final ArrayList<String> authorities;
    private boolean isAsset;
    private final boolean html5mode;
    private final JSInjector jsInjector;
    private final Bridge bridge;

    WebViewLocalServer(Context context, Bridge bridge, JSInjector jsInjector, ArrayList<String> authorities, boolean html5mode) {
        this.html5mode = html5mode;
        this.protocolHandler = new AndroidProtocolHandler(context.getApplicationContext());
        this.authorities = authorities;
        this.bridge = bridge;
        this.jsInjector = jsInjector;
    }

    private static Uri parseAndVerifyUrl(String url) {
        if (url == null) {
            return null;
        }
        Uri uri = Uri.parse((String)url);
        if (uri == null) {
            Logger.error("Malformed URL: " + url);
            return null;
        }
        String path = uri.getPath();
        if (path == null || path.isEmpty()) {
            Logger.error("URL does not have a path: " + url);
            return null;
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebResourceResponse shouldInterceptRequest(WebResourceRequest request) {
        PathHandler handler;
        Uri loadingUrl = request.getUrl();
        if (null != loadingUrl.getPath() && loadingUrl.getPath().startsWith("/_capacitor_http_interceptor_")) {
            Logger.debug("Handling CapacitorHttp request: " + loadingUrl);
            try {
                return this.handleCapacitorHttpRequest(request);
            }
            catch (Exception e) {
                Logger.error(e.getLocalizedMessage());
                return null;
            }
        }
        UriMatcher uriMatcher = this.uriMatcher;
        synchronized (uriMatcher) {
            handler = (PathHandler)this.uriMatcher.match(request.getUrl());
        }
        if (handler == null) {
            return null;
        }
        if (this.isLocalFile(loadingUrl) || this.isMainUrl(loadingUrl) || !this.isAllowedUrl(loadingUrl) || this.isErrorUrl(loadingUrl)) {
            Logger.debug("Handling local request: " + request.getUrl().toString());
            return this.handleLocalRequest(request, handler);
        }
        return this.handleProxyRequest(request, handler);
    }

    private boolean isLocalFile(Uri uri) {
        String path = uri.getPath();
        return path.startsWith(capacitorContentStart) || path.startsWith(capacitorFileStart);
    }

    private boolean isErrorUrl(Uri uri) {
        String url = uri.toString();
        return url.equals(this.bridge.getErrorUrl());
    }

    private boolean isMainUrl(Uri loadingUrl) {
        return this.bridge.getServerUrl() == null && loadingUrl.getHost().equalsIgnoreCase(this.bridge.getHost());
    }

    private boolean isAllowedUrl(Uri loadingUrl) {
        return this.bridge.getServerUrl() != null || this.bridge.getAppAllowNavigationMask().matches(loadingUrl.getHost());
    }

    private String getReasonPhraseFromResponseCode(int code) {
        return switch (code) {
            case 100 -> "Continue";
            case 101 -> "Switching Protocols";
            case 200 -> "OK";
            case 201 -> "Created";
            case 202 -> "Accepted";
            case 203 -> "Non-Authoritative Information";
            case 204 -> "No Content";
            case 205 -> "Reset Content";
            case 206 -> "Partial Content";
            case 300 -> "Multiple Choices";
            case 301 -> "Moved Permanently";
            case 302 -> "Found";
            case 303 -> "See Other";
            case 304 -> "Not Modified";
            case 400 -> "Bad Request";
            case 401 -> "Unauthorized";
            case 403 -> "Forbidden";
            case 404 -> "Not Found";
            case 405 -> "Method Not Allowed";
            case 406 -> "Not Acceptable";
            case 407 -> "Proxy Authentication Required";
            case 408 -> "Request Timeout";
            case 409 -> "Conflict";
            case 410 -> "Gone";
            case 500 -> "Internal Server Error";
            case 501 -> "Not Implemented";
            case 502 -> "Bad Gateway";
            case 503 -> "Service Unavailable";
            case 504 -> "Gateway Timeout";
            case 505 -> "HTTP Version Not Supported";
            default -> "Unknown";
        };
    }

    private WebResourceResponse handleCapacitorHttpRequest(WebResourceRequest request) throws IOException {
        String urlString = request.getUrl().getQueryParameter("u");
        URL url = new URL(urlString);
        JSObject headers = new JSObject();
        for (Map.Entry header : request.getRequestHeaders().entrySet()) {
            headers.put((String)header.getKey(), (String)header.getValue());
        }
        String userAgentValue = headers.getString("x-cap-user-agent");
        if (userAgentValue != null) {
            headers.put("User-Agent", userAgentValue);
        }
        headers.remove("x-cap-user-agent");
        HttpRequestHandler.HttpURLConnectionBuilder connectionBuilder = new HttpRequestHandler.HttpURLConnectionBuilder().setUrl(url).setMethod(request.getMethod()).setHeaders(headers).openConnection();
        CapacitorHttpUrlConnection connection = connectionBuilder.build();
        if (!HttpRequestHandler.isDomainExcludedFromSSL(this.bridge, url).booleanValue()) {
            connection.setSSLSocketFactory(this.bridge);
        }
        connection.connect();
        String mimeType = null;
        String encoding = null;
        LinkedHashMap<String, String> responseHeaders = new LinkedHashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            StringBuilder builder = new StringBuilder();
            for (String value : entry.getValue()) {
                builder.append(value);
                builder.append(", ");
            }
            builder.setLength(builder.length() - 2);
            if ("Content-Type".equalsIgnoreCase(entry.getKey())) {
                String[] encodingParts;
                String[] contentTypeParts = builder.toString().split(";");
                mimeType = contentTypeParts[0].trim();
                if (contentTypeParts.length <= 1 || (encodingParts = contentTypeParts[1].split("=")).length <= 1) continue;
                encoding = encodingParts[1].trim();
                continue;
            }
            responseHeaders.put(entry.getKey(), builder.toString());
        }
        InputStream inputStream = connection.getErrorStream();
        if (inputStream == null) {
            inputStream = connection.getInputStream();
        }
        if (null == mimeType) {
            mimeType = this.getMimeType(request.getUrl().getPath(), inputStream);
        }
        int responseCode = connection.getResponseCode();
        String reasonPhrase = this.getReasonPhraseFromResponseCode(responseCode);
        return new WebResourceResponse(mimeType, encoding, responseCode, reasonPhrase, responseHeaders, inputStream);
    }

    private WebResourceResponse handleLocalRequest(WebResourceRequest request, PathHandler handler) {
        int periodIndex;
        String path = request.getUrl().getPath();
        if (request.getRequestHeaders().get("Range") != null) {
            LollipopLazyInputStream responseStream = new LollipopLazyInputStream(handler, request);
            String mimeType = this.getMimeType(path, responseStream);
            Map<String, String> tempResponseHeaders = handler.getResponseHeaders();
            int statusCode = 206;
            try {
                int totalRange = ((InputStream)responseStream).available();
                String rangeString = (String)request.getRequestHeaders().get("Range");
                String[] parts = rangeString.split("=");
                String[] streamParts = parts[1].split("-");
                String fromRange = streamParts[0];
                int range = totalRange - 1;
                if (streamParts.length > 1) {
                    range = Integer.parseInt(streamParts[1]);
                }
                tempResponseHeaders.put("Accept-Ranges", "bytes");
                tempResponseHeaders.put("Content-Range", "bytes " + fromRange + "-" + range + "/" + totalRange);
            }
            catch (IOException e) {
                statusCode = 404;
            }
            return new WebResourceResponse(mimeType, handler.getEncoding(), statusCode, handler.getReasonPhrase(), tempResponseHeaders, (InputStream)responseStream);
        }
        if (this.isLocalFile(request.getUrl()) || this.isErrorUrl(request.getUrl())) {
            LollipopLazyInputStream responseStream = new LollipopLazyInputStream(handler, request);
            String mimeType = this.getMimeType(request.getUrl().getPath(), responseStream);
            int statusCode = this.getStatusCode(responseStream, handler.getStatusCode());
            return new WebResourceResponse(mimeType, handler.getEncoding(), statusCode, handler.getReasonPhrase(), handler.getResponseHeaders(), (InputStream)responseStream);
        }
        if (path.equals("/cordova.js")) {
            return new WebResourceResponse("application/javascript", handler.getEncoding(), handler.getStatusCode(), handler.getReasonPhrase(), handler.getResponseHeaders(), null);
        }
        if (path.equals("/") || !request.getUrl().getLastPathSegment().contains(".") && this.html5mode) {
            InputStream responseStream;
            try {
                String startPath = this.basePath + "/index.html";
                if (this.bridge.getRouteProcessor() != null) {
                    ProcessedRoute processedRoute = this.bridge.getRouteProcessor().process(this.basePath, "/index.html");
                    startPath = processedRoute.getPath();
                    this.isAsset = processedRoute.isAsset();
                }
                responseStream = this.isAsset ? this.protocolHandler.openAsset(startPath) : this.protocolHandler.openFile(startPath);
            }
            catch (IOException e) {
                Logger.error("Unable to open index.html", e);
                return null;
            }
            if (this.jsInjector != null) {
                responseStream = this.jsInjector.getInjectedStream(responseStream);
            }
            int statusCode = this.getStatusCode(responseStream, handler.getStatusCode());
            return new WebResourceResponse("text/html", handler.getEncoding(), statusCode, handler.getReasonPhrase(), handler.getResponseHeaders(), responseStream);
        }
        if ("/favicon.ico".equalsIgnoreCase(path)) {
            try {
                return new WebResourceResponse("image/png", null, null);
            }
            catch (Exception e) {
                Logger.error("favicon handling failed", e);
            }
        }
        if ((periodIndex = path.lastIndexOf(".")) >= 0) {
            String ext = path.substring(path.lastIndexOf("."));
            InputStream responseStream = new LollipopLazyInputStream(handler, request);
            if (ext.equals(".html") && this.jsInjector != null) {
                responseStream = this.jsInjector.getInjectedStream(responseStream);
            }
            String mimeType = this.getMimeType(path, responseStream);
            int statusCode = this.getStatusCode(responseStream, handler.getStatusCode());
            return new WebResourceResponse(mimeType, handler.getEncoding(), statusCode, handler.getReasonPhrase(), handler.getResponseHeaders(), responseStream);
        }
        return null;
    }

    public InputStream getJavaScriptInjectedStream(InputStream original) {
        if (this.jsInjector != null) {
            return this.jsInjector.getInjectedStream(original);
        }
        return original;
    }

    private WebResourceResponse handleProxyRequest(WebResourceRequest request, PathHandler handler) {
        String method;
        if (this.jsInjector != null && (method = request.getMethod()).equals("GET")) {
            try {
                String url = request.getUrl().toString();
                Map headers = request.getRequestHeaders();
                boolean isHtmlText = false;
                for (Map.Entry header : headers.entrySet()) {
                    if (!((String)header.getKey()).equalsIgnoreCase("Accept") || !((String)header.getValue()).toLowerCase().contains("text/html")) continue;
                    isHtmlText = true;
                    break;
                }
                if (isHtmlText) {
                    List<String> list;
                    HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                    for (Map.Entry entry : headers.entrySet()) {
                        conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                    String getCookie = CookieManager.getInstance().getCookie(url);
                    if (getCookie != null) {
                        conn.setRequestProperty("Cookie", getCookie);
                    }
                    conn.setRequestMethod(method);
                    conn.setReadTimeout(30000);
                    conn.setConnectTimeout(30000);
                    if (request.getUrl().getUserInfo() != null) {
                        byte[] byArray = request.getUrl().getUserInfo().getBytes(StandardCharsets.UTF_8);
                        String base64 = Base64.encodeToString((byte[])byArray, (int)2);
                        conn.setRequestProperty("Authorization", "Basic " + (String)base64);
                    }
                    if ((list = conn.getHeaderFields().get("Set-Cookie")) != null) {
                        for (String cookie : list) {
                            CookieManager.getInstance().setCookie(url, cookie);
                        }
                    }
                    InputStream responseStream = conn.getInputStream();
                    responseStream = this.jsInjector.getInjectedStream(responseStream);
                    return new WebResourceResponse("text/html", handler.getEncoding(), handler.getStatusCode(), handler.getReasonPhrase(), handler.getResponseHeaders(), responseStream);
                }
            }
            catch (Exception ex) {
                this.bridge.handleAppUrlLoadError(ex);
            }
        }
        return null;
    }

    private String getMimeType(String path, InputStream stream) {
        String mimeType = null;
        try {
            mimeType = URLConnection.guessContentTypeFromName(path);
            if (mimeType != null && path.endsWith(".js") && mimeType.equals("image/x-icon")) {
                Logger.debug("We shouldn't be here");
            }
            if (mimeType == null) {
                mimeType = path.endsWith(".js") || path.endsWith(".mjs") ? "application/javascript" : (path.endsWith(".wasm") ? "application/wasm" : URLConnection.guessContentTypeFromStream(stream));
            }
        }
        catch (Exception ex) {
            Logger.error("Unable to get mime type" + path, ex);
        }
        return mimeType;
    }

    private int getStatusCode(InputStream stream, int defaultCode) {
        int finalStatusCode = defaultCode;
        try {
            if (stream.available() == -1) {
                finalStatusCode = 404;
            }
        }
        catch (IOException e) {
            finalStatusCode = 500;
        }
        return finalStatusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Uri uri, PathHandler handler) {
        UriMatcher uriMatcher = this.uriMatcher;
        synchronized (uriMatcher) {
            this.uriMatcher.addURI(uri.getScheme(), uri.getAuthority(), uri.getPath(), handler);
        }
    }

    public void hostAssets(String assetPath) {
        this.isAsset = true;
        this.basePath = assetPath;
        this.createHostingDetails();
    }

    public void hostFiles(String basePath) {
        this.isAsset = false;
        this.basePath = basePath;
        this.createHostingDetails();
    }

    private void createHostingDetails() {
        final String assetPath = this.basePath;
        if (assetPath.indexOf(42) != -1) {
            throw new IllegalArgumentException("assetPath cannot contain the '*' character.");
        }
        PathHandler handler = new PathHandler(this){
            final /* synthetic */ WebViewLocalServer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public InputStream handle(Uri url) {
                InputStream stream = null;
                String path = url.getPath();
                RouteProcessor routeProcessor = this.this$0.bridge.getRouteProcessor();
                boolean ignoreAssetPath = false;
                if (routeProcessor != null) {
                    ProcessedRoute processedRoute = this.this$0.bridge.getRouteProcessor().process("", path);
                    path = processedRoute.getPath();
                    this.this$0.isAsset = processedRoute.isAsset();
                    ignoreAssetPath = processedRoute.isIgnoreAssetPath();
                }
                try {
                    if (path.startsWith(WebViewLocalServer.capacitorContentStart)) {
                        stream = this.this$0.protocolHandler.openContentUrl(url);
                    } else if (path.startsWith(WebViewLocalServer.capacitorFileStart)) {
                        stream = this.this$0.protocolHandler.openFile(path);
                    } else if (!this.this$0.isAsset) {
                        if (routeProcessor == null) {
                            path = this.this$0.basePath + url.getPath();
                        }
                        stream = this.this$0.protocolHandler.openFile(path);
                    } else {
                        stream = ignoreAssetPath ? this.this$0.protocolHandler.openAsset(path) : this.this$0.protocolHandler.openAsset(assetPath + path);
                    }
                }
                catch (IOException e) {
                    Logger.error("Unable to open asset URL: " + url);
                    return null;
                }
                return stream;
            }
        };
        for (String authority : this.authorities) {
            this.registerUriForScheme("http", handler, authority);
            this.registerUriForScheme("https", handler, authority);
            String customScheme = this.bridge.getScheme();
            if (customScheme.equals("http") || customScheme.equals("https")) continue;
            this.registerUriForScheme(customScheme, handler, authority);
        }
    }

    private void registerUriForScheme(String scheme, PathHandler handler, String authority) {
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.scheme(scheme);
        uriBuilder.authority(authority);
        uriBuilder.path("");
        Uri uriPrefix = uriBuilder.build();
        this.register(Uri.withAppendedPath((Uri)uriPrefix, (String)"/"), handler);
        this.register(Uri.withAppendedPath((Uri)uriPrefix, (String)"**"), handler);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public static abstract class PathHandler {
        protected String mimeType;
        private String encoding;
        private String charset;
        private int statusCode;
        private String reasonPhrase;
        private Map<String, String> responseHeaders;

        public PathHandler() {
            this(null, null, 200, "OK", null);
        }

        public PathHandler(String encoding, String charset, int statusCode, String reasonPhrase, Map<String, String> responseHeaders) {
            this.encoding = encoding;
            this.charset = charset;
            this.statusCode = statusCode;
            this.reasonPhrase = reasonPhrase;
            Map<String, String> tempResponseHeaders = responseHeaders == null ? new HashMap<String, String>() : responseHeaders;
            tempResponseHeaders.put("Cache-Control", "no-cache");
            this.responseHeaders = tempResponseHeaders;
        }

        public InputStream handle(WebResourceRequest request) {
            return this.handle(request.getUrl());
        }

        public abstract InputStream handle(Uri var1);

        public String getEncoding() {
            return this.encoding;
        }

        public String getCharset() {
            return this.charset;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getReasonPhrase() {
            return this.reasonPhrase;
        }

        public Map<String, String> getResponseHeaders() {
            return this.responseHeaders;
        }
    }

    private static class LollipopLazyInputStream
    extends LazyInputStream {
        private WebResourceRequest request;
        private InputStream is;

        public LollipopLazyInputStream(PathHandler handler, WebResourceRequest request) {
            super(handler);
            this.request = request;
        }

        @Override
        protected InputStream handle() {
            return this.handler.handle(this.request);
        }
    }

    private static abstract class LazyInputStream
    extends InputStream {
        protected final PathHandler handler;
        private InputStream is = null;

        public LazyInputStream(PathHandler handler) {
            this.handler = handler;
        }

        private InputStream getInputStream() {
            if (this.is == null) {
                this.is = this.handle();
            }
            return this.is;
        }

        protected abstract InputStream handle();

        @Override
        public int available() throws IOException {
            InputStream is = this.getInputStream();
            return is != null ? is.available() : -1;
        }

        @Override
        public int read() throws IOException {
            InputStream is = this.getInputStream();
            return is != null ? is.read() : -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            InputStream is = this.getInputStream();
            return is != null ? is.read(b) : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            InputStream is = this.getInputStream();
            return is != null ? is.read(b, off, len) : -1;
        }

        @Override
        public long skip(long n) throws IOException {
            InputStream is = this.getInputStream();
            return is != null ? is.skip(n) : 0L;
        }
    }
}

