/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.MimeTypeMap;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.EditText;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.FileProvider;
import com.getcapacitor.Bridge;
import com.getcapacitor.Logger;
import com.getcapacitor.util.PermissionHelper;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class BridgeWebChromeClient
extends WebChromeClient {
    private ActivityResultLauncher permissionLauncher;
    private ActivityResultLauncher activityLauncher;
    private PermissionListener permissionListener;
    private ActivityResultListener activityListener;
    private Bridge bridge;

    public BridgeWebChromeClient(Bridge bridge) {
        this.bridge = bridge;
        ActivityResultCallback permissionCallback = isGranted -> {
            if (this.permissionListener != null) {
                boolean granted = true;
                for (Map.Entry permission2 : isGranted.entrySet()) {
                    if (((Boolean)permission2.getValue()).booleanValue()) continue;
                    granted = false;
                }
                this.permissionListener.onPermissionSelect(granted);
            }
        };
        this.permissionLauncher = bridge.registerForActivityResult(new ActivityResultContracts.RequestMultiplePermissions(), permissionCallback);
        this.activityLauncher = bridge.registerForActivityResult(new ActivityResultContracts.StartActivityForResult(), result -> {
            if (this.activityListener != null) {
                this.activityListener.onActivityResult((ActivityResult)result);
            }
        });
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        callback.onCustomViewHidden();
        super.onShowCustomView(view, callback);
    }

    public void onHideCustomView() {
        super.onHideCustomView();
    }

    public void onPermissionRequest(PermissionRequest request) {
        ArrayList<String> permissionList = new ArrayList<String>();
        if (Arrays.asList(request.getResources()).contains("android.webkit.resource.VIDEO_CAPTURE")) {
            permissionList.add("android.permission.CAMERA");
        }
        if (Arrays.asList(request.getResources()).contains("android.webkit.resource.AUDIO_CAPTURE")) {
            permissionList.add("android.permission.MODIFY_AUDIO_SETTINGS");
            permissionList.add("android.permission.RECORD_AUDIO");
        }
        if (!permissionList.isEmpty()) {
            String[] permissions = permissionList.toArray(new String[0]);
            this.permissionListener = isGranted -> {
                if (isGranted.booleanValue()) {
                    request.grant(request.getResources());
                } else {
                    request.deny();
                }
            };
            this.permissionLauncher.launch((Object)permissions);
        } else {
            request.grant(request.getResources());
        }
    }

    public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
        if (this.bridge.getActivity().isFinishing()) {
            return true;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext());
        builder.setMessage((CharSequence)message).setPositiveButton((CharSequence)"OK", (dialog, buttonIndex) -> {
            dialog.dismiss();
            result.confirm();
        }).setOnCancelListener(dialog -> {
            dialog.dismiss();
            result.cancel();
        });
        AlertDialog dialog2 = builder.create();
        dialog2.show();
        return true;
    }

    public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
        if (this.bridge.getActivity().isFinishing()) {
            return true;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext());
        builder.setMessage((CharSequence)message).setPositiveButton((CharSequence)"OK", (dialog, buttonIndex) -> {
            dialog.dismiss();
            result.confirm();
        }).setNegativeButton((CharSequence)"Cancel", (dialog, buttonIndex) -> {
            dialog.dismiss();
            result.cancel();
        }).setOnCancelListener(dialog -> {
            dialog.dismiss();
            result.cancel();
        });
        AlertDialog dialog2 = builder.create();
        dialog2.show();
        return true;
    }

    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        if (this.bridge.getActivity().isFinishing()) {
            return true;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext());
        EditText input = new EditText(view.getContext());
        builder.setMessage((CharSequence)message).setView((View)input).setPositiveButton((CharSequence)"OK", (dialog, buttonIndex) -> {
            dialog.dismiss();
            String inputText1 = input.getText().toString().trim();
            result.confirm(inputText1);
        }).setNegativeButton((CharSequence)"Cancel", (dialog, buttonIndex) -> {
            dialog.dismiss();
            result.cancel();
        }).setOnCancelListener(dialog -> {
            dialog.dismiss();
            result.cancel();
        });
        AlertDialog dialog2 = builder.create();
        dialog2.show();
        return true;
    }

    public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        super.onGeolocationPermissionsShowPrompt(origin, callback);
        Logger.debug("onGeolocationPermissionsShowPrompt: DOING IT HERE FOR ORIGIN: " + origin);
        String[] geoPermissions = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};
        if (!PermissionHelper.hasPermissions(this.bridge.getContext(), geoPermissions)) {
            this.permissionListener = isGranted -> {
                if (isGranted.booleanValue()) {
                    callback.invoke(origin, true, false);
                } else {
                    String[] coarsePermission = new String[]{"android.permission.ACCESS_COARSE_LOCATION"};
                    if (Build.VERSION.SDK_INT >= 31 && PermissionHelper.hasPermissions(this.bridge.getContext(), coarsePermission)) {
                        callback.invoke(origin, true, false);
                    } else {
                        callback.invoke(origin, false, false);
                    }
                }
            };
            this.permissionLauncher.launch((Object)geoPermissions);
        } else {
            callback.invoke(origin, true, false);
            Logger.debug("onGeolocationPermissionsShowPrompt: has required permission");
        }
    }

    public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        boolean captureVideo;
        List<String> acceptTypes = Arrays.asList(fileChooserParams.getAcceptTypes());
        boolean captureEnabled = fileChooserParams.isCaptureEnabled();
        boolean capturePhoto = captureEnabled && acceptTypes.contains("image/*");
        boolean bl = captureVideo = captureEnabled && acceptTypes.contains("video/*");
        if (capturePhoto || captureVideo) {
            if (this.isMediaCaptureSupported()) {
                this.showMediaCaptureOrFilePicker(filePathCallback, fileChooserParams, captureVideo);
            } else {
                this.permissionListener = isGranted -> {
                    if (isGranted.booleanValue()) {
                        this.showMediaCaptureOrFilePicker(filePathCallback, fileChooserParams, captureVideo);
                    } else {
                        Logger.warn(Logger.tags("FileChooser"), "Camera permission not granted");
                        filePathCallback.onReceiveValue(null);
                    }
                };
                String[] camPermission = new String[]{"android.permission.CAMERA"};
                this.permissionLauncher.launch((Object)camPermission);
            }
        } else {
            this.showFilePicker(filePathCallback, fileChooserParams);
        }
        return true;
    }

    private boolean isMediaCaptureSupported() {
        String[] permissions = new String[]{"android.permission.CAMERA"};
        return PermissionHelper.hasPermissions(this.bridge.getContext(), permissions) || !PermissionHelper.hasDefinedPermission(this.bridge.getContext(), "android.permission.CAMERA");
    }

    private void showMediaCaptureOrFilePicker(ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams, boolean isVideo) {
        boolean isVideoCaptureSupported = Build.VERSION.SDK_INT >= 24;
        boolean shown = false;
        shown = isVideo && isVideoCaptureSupported ? this.showVideoCapturePicker(filePathCallback) : this.showImageCapturePicker(filePathCallback);
        if (!shown) {
            Logger.warn(Logger.tags("FileChooser"), "Media capture intent could not be launched. Falling back to default file picker.");
            this.showFilePicker(filePathCallback, fileChooserParams);
        }
    }

    @SuppressLint(value={"QueryPermissionsNeeded"})
    private boolean showImageCapturePicker(ValueCallback<Uri[]> filePathCallback) {
        Uri imageFileUri;
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.bridge.getActivity().getPackageManager()) == null) {
            return false;
        }
        try {
            imageFileUri = this.createImageFileUri();
        }
        catch (Exception ex) {
            Logger.error("Unable to create temporary media capture file: " + ex.getMessage());
            return false;
        }
        takePictureIntent.putExtra("output", (Parcelable)imageFileUri);
        this.activityListener = activityResult -> {
            Uri[] result = null;
            if (activityResult.getResultCode() == -1) {
                result = new Uri[]{imageFileUri};
            }
            filePathCallback.onReceiveValue(result);
        };
        this.activityLauncher.launch((Object)takePictureIntent);
        return true;
    }

    @SuppressLint(value={"QueryPermissionsNeeded"})
    private boolean showVideoCapturePicker(ValueCallback<Uri[]> filePathCallback) {
        Intent takeVideoIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (takeVideoIntent.resolveActivity(this.bridge.getActivity().getPackageManager()) == null) {
            return false;
        }
        this.activityListener = activityResult -> {
            Uri[] result = null;
            if (activityResult.getResultCode() == -1) {
                result = new Uri[]{activityResult.getData().getData()};
            }
            filePathCallback.onReceiveValue(result);
        };
        this.activityLauncher.launch((Object)takeVideoIntent);
        return true;
    }

    private void showFilePicker(ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        Intent intent = fileChooserParams.createIntent();
        if (fileChooserParams.getMode() == 1) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        if (fileChooserParams.getAcceptTypes().length > 1 || intent.getType().startsWith(".")) {
            String[] validTypes = this.getValidTypes(fileChooserParams.getAcceptTypes());
            intent.putExtra("android.intent.extra.MIME_TYPES", validTypes);
            if (intent.getType().startsWith(".")) {
                intent.setType(validTypes[0]);
            }
        }
        try {
            this.activityListener = activityResult -> {
                Uri[] result;
                Intent resultIntent = activityResult.getData();
                if (activityResult.getResultCode() == -1 && resultIntent.getClipData() != null) {
                    int numFiles = resultIntent.getClipData().getItemCount();
                    result = new Uri[numFiles];
                    for (int i = 0; i < numFiles; ++i) {
                        result[i] = resultIntent.getClipData().getItemAt(i).getUri();
                    }
                } else {
                    result = WebChromeClient.FileChooserParams.parseResult((int)activityResult.getResultCode(), (Intent)resultIntent);
                }
                filePathCallback.onReceiveValue((Object)result);
            };
            this.activityLauncher.launch((Object)intent);
        }
        catch (ActivityNotFoundException e) {
            filePathCallback.onReceiveValue(null);
        }
    }

    private String[] getValidTypes(String[] currentTypes) {
        ArrayList<String> validTypes = new ArrayList<String>();
        MimeTypeMap mtm = MimeTypeMap.getSingleton();
        for (String mime : currentTypes) {
            if (mime.startsWith(".")) {
                String extension = mime.substring(1);
                String extensionMime = mtm.getMimeTypeFromExtension(extension);
                if (extensionMime == null || validTypes.contains(extensionMime)) continue;
                validTypes.add(extensionMime);
                continue;
            }
            if (validTypes.contains(mime)) continue;
            validTypes.add(mime);
        }
        Object[] validObj = validTypes.toArray();
        return (String[])Arrays.copyOf(validObj, validObj.length, String[].class);
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        String tag = Logger.tags("Console");
        if (consoleMessage.message() != null && this.isValidMsg(consoleMessage.message())) {
            String msg = String.format("File: %s - Line %d - Msg: %s", consoleMessage.sourceId(), consoleMessage.lineNumber(), consoleMessage.message());
            String level = consoleMessage.messageLevel().name();
            if ("ERROR".equalsIgnoreCase(level)) {
                Logger.error(tag, msg, null);
            } else if ("WARNING".equalsIgnoreCase(level)) {
                Logger.warn(tag, msg);
            } else if ("TIP".equalsIgnoreCase(level)) {
                Logger.debug(tag, msg);
            } else {
                Logger.info(tag, msg);
            }
        }
        return true;
    }

    public boolean isValidMsg(String msg) {
        return !msg.contains("%cresult %c") && !msg.contains("%cnative %c") && !msg.equalsIgnoreCase("[object Object]") && !msg.equalsIgnoreCase("console.groupEnd");
    }

    private Uri createImageFileUri() throws IOException {
        AppCompatActivity activity = this.bridge.getActivity();
        File photoFile = this.createImageFile((Activity)activity);
        return FileProvider.getUriForFile((Context)activity, (String)(this.bridge.getContext().getPackageName() + ".fileprovider"), (File)photoFile);
    }

    private File createImageFile(Activity activity) throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = activity.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        return File.createTempFile(imageFileName, ".jpg", storageDir);
    }

    private static interface PermissionListener {
        public void onPermissionSelect(Boolean var1);
    }

    private static interface ActivityResultListener {
        public void onActivityResult(ActivityResult var1);
    }
}

