/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.statusbar;

import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import com.capacitorjs.plugins.statusbar.StatusBarConfig;
import com.capacitorjs.plugins.statusbar.StatusBarInfo;

public class StatusBar {
    public static final String statusBarVisibilityChanged = "statusBarVisibilityChanged";
    public static final String statusBarOverlayChanged = "statusBarOverlayChanged";
    private int currentStatusBarColor;
    private final ChangeListener listener;
    private final AppCompatActivity activity;
    private String currentStyle = "DEFAULT";

    public StatusBar(AppCompatActivity activity, StatusBarConfig config, ChangeListener listener) {
        this.activity = activity;
        this.currentStatusBarColor = activity.getWindow().getStatusBarColor();
        this.listener = listener;
        this.setBackgroundColor(config.getBackgroundColor());
        this.setStyle(config.getStyle());
        this.setOverlaysWebView(config.isOverlaysWebView());
        StatusBarInfo info = this.getInfo();
        info.setVisible(true);
        listener.onChange(statusBarOverlayChanged, info);
    }

    public void setStyle(String style) {
        Window window = this.activity.getWindow();
        View decorView = window.getDecorView();
        this.currentStyle = style;
        if (style.equals("DEFAULT")) {
            style = this.getStyleForTheme();
        }
        WindowInsetsControllerCompat windowInsetsControllerCompat = WindowCompat.getInsetsController((Window)window, (View)decorView);
        windowInsetsControllerCompat.setAppearanceLightStatusBars(!style.equals("DARK"));
    }

    private String getStyleForTheme() {
        int currentNightMode = this.activity.getResources().getConfiguration().uiMode & 0x30;
        if (currentNightMode != 32) {
            return "LIGHT";
        }
        return "DARK";
    }

    public void updateStyle() {
        this.setStyle(this.currentStyle);
    }

    public void setBackgroundColor(int color) {
        Window window = this.activity.getWindow();
        window.clearFlags(0x4000000);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(color);
        this.currentStatusBarColor = color;
    }

    public void hide() {
        View decorView = this.activity.getWindow().getDecorView();
        WindowInsetsControllerCompat windowInsetsControllerCompat = WindowCompat.getInsetsController((Window)this.activity.getWindow(), (View)decorView);
        windowInsetsControllerCompat.hide(WindowInsetsCompat.Type.statusBars());
        StatusBarInfo info = this.getInfo();
        info.setVisible(false);
        this.listener.onChange(statusBarVisibilityChanged, info);
    }

    public void show() {
        View decorView = this.activity.getWindow().getDecorView();
        WindowInsetsControllerCompat windowInsetsControllerCompat = WindowCompat.getInsetsController((Window)this.activity.getWindow(), (View)decorView);
        windowInsetsControllerCompat.show(WindowInsetsCompat.Type.statusBars());
        StatusBarInfo info = this.getInfo();
        info.setVisible(true);
        this.listener.onChange(statusBarVisibilityChanged, info);
    }

    public void setOverlaysWebView(Boolean overlays) {
        View decorView = this.activity.getWindow().getDecorView();
        int uiOptions = decorView.getSystemUiVisibility();
        if (overlays.booleanValue()) {
            uiOptions = uiOptions | 0x100 | 0x400;
            decorView.setSystemUiVisibility(uiOptions);
            this.currentStatusBarColor = this.activity.getWindow().getStatusBarColor();
            this.activity.getWindow().setStatusBarColor(0);
        } else {
            uiOptions = uiOptions & 0xFFFFFEFF & 0xFFFFFBFF;
            decorView.setSystemUiVisibility(uiOptions);
            this.activity.getWindow().setStatusBarColor(this.currentStatusBarColor);
        }
        this.listener.onChange(statusBarOverlayChanged, this.getInfo());
    }

    private boolean getIsOverlaid() {
        return (this.activity.getWindow().getDecorView().getSystemUiVisibility() & 0x400) == 1024;
    }

    public StatusBarInfo getInfo() {
        Window window = this.activity.getWindow();
        WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)window.getDecorView());
        boolean isVisible = windowInsetsCompat != null && windowInsetsCompat.isVisible(WindowInsetsCompat.Type.statusBars());
        StatusBarInfo info = new StatusBarInfo();
        info.setStyle(this.getStyle());
        info.setOverlays(this.getIsOverlaid());
        info.setVisible(isVisible);
        info.setColor(String.format("#%06X", 0xFFFFFF & window.getStatusBarColor()));
        info.setHeight(this.getStatusBarHeight());
        return info;
    }

    private String getStyle() {
        View decorView = this.activity.getWindow().getDecorView();
        String style = "DARK";
        WindowInsetsControllerCompat windowInsetsControllerCompat = WindowCompat.getInsetsController((Window)this.activity.getWindow(), (View)decorView);
        if (windowInsetsControllerCompat.isAppearanceLightStatusBars()) {
            style = "LIGHT";
        }
        return style;
    }

    private int getStatusBarHeight() {
        DisplayMetrics metrics = this.activity.getResources().getDisplayMetrics();
        if (Build.VERSION.SDK_INT >= 30) {
            WindowInsets insets = this.activity.getWindowManager().getCurrentWindowMetrics().getWindowInsets();
            return (int)((float)insets.getInsets((int)WindowInsets.Type.statusBars()).top / metrics.density);
        }
        WindowInsets insets = this.activity.getWindow().getDecorView().getRootWindowInsets();
        if (insets != null) {
            return (int)((float)insets.getSystemWindowInsetTop() / metrics.density);
        }
        return 0;
    }

    public static interface ChangeListener {
        public void onChange(String var1, StatusBarInfo var2);
    }
}

