/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor.plugin.util;

import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.Base64;
import com.getcapacitor.Bridge;
import com.getcapacitor.JSArray;
import com.getcapacitor.JSObject;
import com.getcapacitor.JSValue;
import com.getcapacitor.PluginCall;
import com.getcapacitor.plugin.util.ICapacitorHttpUrlConnection;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class CapacitorHttpUrlConnection
implements ICapacitorHttpUrlConnection {
    private final HttpURLConnection connection;

    public CapacitorHttpUrlConnection(HttpURLConnection conn) {
        this.connection = conn;
        this.setDefaultRequestProperties();
    }

    public HttpURLConnection getHttpConnection() {
        return this.connection;
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public void setAllowUserInteraction(boolean isAllowedInteraction) {
        this.connection.setAllowUserInteraction(isAllowedInteraction);
    }

    public void setRequestMethod(String method) throws ProtocolException {
        this.connection.setRequestMethod(method);
    }

    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can not be negative");
        }
        this.connection.setConnectTimeout(timeout);
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can not be negative");
        }
        this.connection.setReadTimeout(timeout);
    }

    public void setDisableRedirects(boolean disableRedirects) {
        this.connection.setInstanceFollowRedirects(!disableRedirects);
    }

    public void setRequestHeaders(JSObject headers) {
        Iterator keys = headers.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = headers.getString(key);
            this.connection.setRequestProperty(key, value);
        }
    }

    public void setDoOutput(boolean shouldDoOutput) {
        this.connection.setDoOutput(shouldDoOutput);
    }

    public void setRequestBody(PluginCall call, JSValue body) throws JSONException, IOException {
        this.setRequestBody(call, body, null);
    }

    public void setRequestBody(PluginCall call, JSValue body, String bodyType) throws JSONException, IOException {
        String contentType = this.connection.getRequestProperty("Content-Type");
        String dataString = "";
        if (contentType == null || contentType.isEmpty()) {
            return;
        }
        if (contentType.contains("application/json")) {
            JSArray jsArray = null;
            if (body != null) {
                dataString = body.toString();
            } else {
                jsArray = call.getArray("data", null);
            }
            if (jsArray != null) {
                dataString = jsArray.toString();
            } else if (body == null) {
                dataString = call.getString("data");
            }
            this.writeRequestBody(dataString != null ? dataString : "");
        } else if (bodyType != null && bodyType.equals("file")) {
            try (DataOutputStream os = new DataOutputStream(this.connection.getOutputStream());){
                if (Build.VERSION.SDK_INT >= 26) {
                    os.write(java.util.Base64.getDecoder().decode(body.toString()));
                }
                os.flush();
            }
        } else if (contentType.contains("application/x-www-form-urlencoded")) {
            try {
                JSObject obj = body.toJSObject();
                this.writeObjectRequestBody(obj);
            }
            catch (Exception e) {
                this.writeRequestBody(body.toString());
            }
        } else if (bodyType != null && bodyType.equals("formData")) {
            this.writeFormDataRequestBody(contentType, body.toJSArray());
        } else {
            this.writeRequestBody(body.toString());
        }
    }

    private void writeRequestBody(String body) throws IOException {
        try (DataOutputStream os = new DataOutputStream(this.connection.getOutputStream());){
            os.write(body.getBytes(StandardCharsets.UTF_8));
            os.flush();
        }
    }

    private void writeObjectRequestBody(JSObject object) throws IOException, JSONException {
        try (DataOutputStream os = new DataOutputStream(this.connection.getOutputStream());){
            Iterator keys = object.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object d = object.get(key);
                os.writeBytes(URLEncoder.encode(key, "UTF-8"));
                os.writeBytes("=");
                os.writeBytes(URLEncoder.encode(d.toString(), "UTF-8"));
                if (!keys.hasNext()) continue;
                os.writeBytes("&");
            }
            os.flush();
        }
    }

    private void writeFormDataRequestBody(String contentType, JSArray entries) throws IOException, JSONException {
        try (DataOutputStream os = new DataOutputStream(this.connection.getOutputStream());){
            String boundary = contentType.split(";")[1].split("=")[1];
            String lineEnd = "\r\n";
            String twoHyphens = "--";
            for (Object e : entries.toList()) {
                if (!(e instanceof JSONObject)) continue;
                JSONObject entry = (JSONObject)e;
                String type = entry.getString("type");
                String key = entry.getString("key");
                String value = entry.getString("value");
                if (type.equals("string")) {
                    os.writeBytes(twoHyphens + boundary + lineEnd);
                    os.writeBytes("Content-Disposition: form-data; name=\"" + key + "\"" + lineEnd + lineEnd);
                    os.write(value.getBytes(StandardCharsets.UTF_8));
                    os.writeBytes(lineEnd);
                    continue;
                }
                if (!type.equals("base64File")) continue;
                String fileName = entry.getString("fileName");
                String fileContentType = entry.getString("contentType");
                os.writeBytes(twoHyphens + boundary + lineEnd);
                os.writeBytes("Content-Disposition: form-data; name=\"" + key + "\"; filename=\"" + fileName + "\"" + lineEnd);
                os.writeBytes("Content-Type: " + fileContentType + lineEnd);
                os.writeBytes("Content-Transfer-Encoding: binary" + lineEnd);
                os.writeBytes(lineEnd);
                if (Build.VERSION.SDK_INT >= 26) {
                    os.write(java.util.Base64.getDecoder().decode(value));
                } else {
                    os.write(Base64.decode((String)value, (int)0));
                }
                os.writeBytes(lineEnd);
            }
            os.writeBytes(twoHyphens + boundary + twoHyphens + lineEnd);
            os.flush();
        }
    }

    public void connect() throws IOException {
        this.connection.connect();
    }

    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    public URL getURL() {
        return this.connection.getURL();
    }

    @Override
    public InputStream getErrorStream() {
        return this.connection.getErrorStream();
    }

    @Override
    public String getHeaderField(String name) {
        return this.connection.getHeaderField(name);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public Map<String, List<String>> getHeaderFields() {
        return this.connection.getHeaderFields();
    }

    private void setDefaultRequestProperties() {
        String acceptLanguage = this.buildDefaultAcceptLanguageProperty();
        if (!TextUtils.isEmpty((CharSequence)acceptLanguage)) {
            this.connection.setRequestProperty("Accept-Language", acceptLanguage);
        }
    }

    private String buildDefaultAcceptLanguageProperty() {
        Locale locale = Build.VERSION.SDK_INT >= 24 ? LocaleList.getDefault().get(0) : Locale.getDefault();
        String result = "";
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if (!TextUtils.isEmpty((CharSequence)lang)) {
            result = !TextUtils.isEmpty((CharSequence)country) ? String.format("%s-%s,%s;q=0.5", lang, country, lang) : String.format("%s;q=0.5", lang);
        }
        return result;
    }

    public void setSSLSocketFactory(Bridge bridge) {
        try {
            Class<?> sslPinningImpl = Class.forName("io.ionic.sslpinning.SSLPinning");
            Method method = sslPinningImpl.getDeclaredMethod("getSSLSocketFactory", Bridge.class);
            SSLSocketFactory sslSocketFactory = (SSLSocketFactory)method.invoke(sslPinningImpl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), bridge);
            if (sslSocketFactory != null) {
                ((HttpsURLConnection)this.connection).setSSLSocketFactory(sslSocketFactory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

