/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import com.getcapacitor.Logger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

class JSInjector {
    private String globalJS;
    private String bridgeJS;
    private String pluginJS;
    private String cordovaJS;
    private String cordovaPluginsJS;
    private String cordovaPluginsFileJS;
    private String localUrlJS;
    private String miscJS;

    public JSInjector(String globalJS, String bridgeJS, String pluginJS, String cordovaJS, String cordovaPluginsJS, String cordovaPluginsFileJS, String localUrlJS) {
        this(globalJS, bridgeJS, pluginJS, cordovaJS, cordovaPluginsJS, cordovaPluginsFileJS, localUrlJS, null);
    }

    public JSInjector(String globalJS, String bridgeJS, String pluginJS, String cordovaJS, String cordovaPluginsJS, String cordovaPluginsFileJS, String localUrlJS, String miscJS) {
        this.globalJS = globalJS;
        this.bridgeJS = bridgeJS;
        this.pluginJS = pluginJS;
        this.cordovaJS = cordovaJS;
        this.cordovaPluginsJS = cordovaPluginsJS;
        this.cordovaPluginsFileJS = cordovaPluginsFileJS;
        this.localUrlJS = localUrlJS;
        this.miscJS = miscJS;
    }

    public String getScriptString() {
        String scriptString = this.globalJS + "\n\n" + this.localUrlJS + "\n\n" + this.bridgeJS + "\n\n" + this.pluginJS + "\n\n" + this.cordovaJS + "\n\n" + this.cordovaPluginsFileJS + "\n\n" + this.cordovaPluginsJS;
        if (this.miscJS != null) {
            scriptString = scriptString + "\n\n" + this.miscJS;
        }
        return scriptString;
    }

    public InputStream getInjectedStream(InputStream responseStream) {
        String js = "<script type=\"text/javascript\">" + this.getScriptString() + "</script>";
        String html = this.readAssetStream(responseStream);
        StringBuilder modifiedHtml = new StringBuilder(html);
        if (html.contains("<head>")) {
            modifiedHtml.insert(html.indexOf("<head>") + "<head>".length(), "\n" + js + "\n");
            html = modifiedHtml.toString();
        } else if (html.contains("</head>")) {
            modifiedHtml.insert(html.indexOf("</head>"), "\n" + js + "\n");
            html = modifiedHtml.toString();
        } else {
            Logger.error("Unable to inject Capacitor, Plugins won't work");
        }
        return new ByteArrayInputStream(html.getBytes(StandardCharsets.UTF_8));
    }

    private String readAssetStream(InputStream stream) {
        try {
            int rsz;
            int bufferSize = 1024;
            char[] buffer = new char[1024];
            StringBuilder out = new StringBuilder();
            InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);
            while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                out.append(buffer, 0, rsz);
            }
            return out.toString();
        }
        catch (Exception e) {
            Logger.error("Unable to process HTML asset file. This is a fatal error", e);
            return "";
        }
    }
}

