/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor.plugin;

import com.getcapacitor.Bridge;
import com.getcapacitor.Logger;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class CapacitorCookieManager
extends CookieManager {
    private final android.webkit.CookieManager webkitCookieManager = android.webkit.CookieManager.getInstance();
    private final String localUrl;
    private final String serverUrl;
    private final String TAG = "CapacitorCookies";

    public CapacitorCookieManager(Bridge bridge) {
        this(null, null, bridge);
    }

    public CapacitorCookieManager(CookieStore store, CookiePolicy policy, Bridge bridge) {
        super(store, policy);
        this.localUrl = bridge.getLocalUrl();
        this.serverUrl = bridge.getServerUrl();
    }

    public void removeSessionCookies() {
        this.webkitCookieManager.removeSessionCookies(null);
    }

    public String getSanitizedDomain(String url) throws URISyntaxException {
        if (this.serverUrl != null && !this.serverUrl.isEmpty() && (url == null || url.isEmpty() || this.serverUrl.contains(url))) {
            url = this.serverUrl;
        } else if (this.localUrl != null && !this.localUrl.isEmpty() && (url == null || url.isEmpty() || this.localUrl.contains(url))) {
            url = this.localUrl;
        } else {
            try {
                URI uri = new URI(url);
                String scheme = uri.getScheme();
                if (scheme == null || scheme.isEmpty()) {
                    url = "https://" + url;
                }
            }
            catch (URISyntaxException e) {
                Logger.error("CapacitorCookies", "Failed to get scheme from URL.", e);
            }
        }
        try {
            new URI(url);
        }
        catch (Exception error) {
            Logger.error("CapacitorCookies", "Failed to get sanitized URL.", error);
            throw error;
        }
        return url;
    }

    private String getDomainFromCookieString(String cookie) throws URISyntaxException {
        String[] domain = cookie.toLowerCase(Locale.ROOT).split("domain=");
        return this.getSanitizedDomain(domain.length <= 1 ? null : domain[1].split(";")[0].trim());
    }

    public String getCookieString(String url) {
        try {
            url = this.getSanitizedDomain(url);
            Logger.info("CapacitorCookies", "Getting cookies at: '" + url + "'");
            return this.webkitCookieManager.getCookie(url);
        }
        catch (Exception error) {
            Logger.error("CapacitorCookies", "Failed to get cookies at the given URL.", error);
            return null;
        }
    }

    public HttpCookie getCookie(String url, String key) {
        HttpCookie[] cookies;
        for (HttpCookie cookie : cookies = this.getCookies(url)) {
            if (!cookie.getName().equals(key)) continue;
            return cookie;
        }
        return null;
    }

    public HttpCookie[] getCookies(String url) {
        try {
            ArrayList<HttpCookie> cookieList = new ArrayList<HttpCookie>();
            String cookieString = this.getCookieString(url);
            if (cookieString != null) {
                String[] singleCookie;
                for (String c : singleCookie = cookieString.split(";")) {
                    HttpCookie parsed = HttpCookie.parse(c).get(0);
                    parsed.setValue(parsed.getValue());
                    cookieList.add(parsed);
                }
            }
            HttpCookie[] cookies = new HttpCookie[cookieList.size()];
            return cookieList.toArray(cookies);
        }
        catch (Exception ex) {
            return new HttpCookie[0];
        }
    }

    public void setCookie(String url, String value) {
        try {
            url = this.getSanitizedDomain(url);
            Logger.info("CapacitorCookies", "Setting cookie '" + value + "' at: '" + url + "'");
            this.webkitCookieManager.setCookie(url, value);
            this.flush();
        }
        catch (Exception error) {
            Logger.error("CapacitorCookies", "Failed to set cookie.", error);
        }
    }

    public void setCookie(String url, String key, String value) {
        String cookieValue = key + "=" + value;
        this.setCookie(url, cookieValue);
    }

    public void setCookie(String url, String key, String value, String expires, String path) {
        String cookieValue = key + "=" + value + "; expires=" + expires + "; path=" + path;
        this.setCookie(url, cookieValue);
    }

    public void removeAllCookies() {
        this.webkitCookieManager.removeAllCookies(null);
        this.flush();
    }

    public void flush() {
        this.webkitCookieManager.flush();
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) {
        if (uri == null || responseHeaders == null) {
            return;
        }
        for (String headerKey : responseHeaders.keySet()) {
            if (headerKey == null || !headerKey.equalsIgnoreCase("Set-Cookie2") && !headerKey.equalsIgnoreCase("Set-Cookie")) continue;
            for (String headerValue : Objects.requireNonNull(responseHeaders.get(headerKey))) {
                try {
                    this.setCookie(uri.toString(), headerValue);
                    this.setCookie(this.getDomainFromCookieString(headerValue), headerValue);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) {
        if (uri == null || requestHeaders == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        String url = uri.toString();
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        String cookie = this.getCookieString(url);
        if (cookie != null) {
            res.put("Cookie", Collections.singletonList(cookie));
        }
        return res;
    }

    @Override
    public CookieStore getCookieStore() {
        throw new UnsupportedOperationException();
    }
}

