/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.webkit.WebView;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.getcapacitor.Bridge;
import com.getcapacitor.CapConfig;

public class CapacitorWebView
extends WebView {
    private BaseInputConnection capInputConnection;
    private Bridge bridge;

    public CapacitorWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setBridge(Bridge bridge) {
        this.bridge = bridge;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        CapConfig config = this.bridge != null ? this.bridge.getConfig() : CapConfig.loadDefault(this.getContext());
        boolean captureInput = config.isInputCaptured();
        if (captureInput) {
            if (this.capInputConnection == null) {
                this.capInputConnection = new BaseInputConnection((View)this, false);
            }
            return this.capInputConnection;
        }
        return super.onCreateInputConnection(outAttrs);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getAction() == 2) {
            this.evaluateJavascript("document.activeElement.value = document.activeElement.value + '" + event.getCharacters() + "';", null);
            return false;
        }
        return super.dispatchKeyEvent(event);
    }

    public void edgeToEdgeHandler(Bridge bridge) {
        String configEdgeToEdge = bridge.getConfig().adjustMarginsForEdgeToEdge();
        if (configEdgeToEdge.equals("disable")) {
            return;
        }
        boolean autoMargins = false;
        boolean forceMargins = configEdgeToEdge.equals("force");
        if (Build.VERSION.SDK_INT >= 35 && configEdgeToEdge.equals("auto")) {
            TypedValue value = new TypedValue();
            boolean foundOptOut = this.getContext().getTheme().resolveAttribute(16844442, value, true);
            boolean optOutValue = value.data != 0;
            boolean bl = autoMargins = !foundOptOut || !optOutValue;
        }
        if (forceMargins || autoMargins) {
            ViewCompat.setOnApplyWindowInsetsListener((View)this, (v, windowInsets) -> {
                Insets insets = windowInsets.getInsets(WindowInsetsCompat.Type.systemBars() | WindowInsetsCompat.Type.displayCutout());
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
                mlp.leftMargin = insets.left;
                mlp.bottomMargin = insets.bottom;
                mlp.rightMargin = insets.right;
                mlp.topMargin = insets.top;
                v.setLayoutParams((ViewGroup.LayoutParams)mlp);
                return WindowInsetsCompat.CONSUMED;
            });
        }
    }
}

