#include <Arduino.h>
#include "Freenove_VK16K33_Lib.h"
#include "Freenove_4WD_Car_Emotion.h"

Freenove_VK16K33 matrix = Freenove_VK16K33();
int emotion_time_next = 0;
int emotion_time_now = 0;
int emotion_count = 0;
int emotion_flag = 0;

//Turn eyes clockwise
byte eyeRotate1[][8] = {
  0x00,
  0x3C,
  0x4E,
  0x4E,
  0x7E,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x66,
  0x66,
  0x7E,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x72,
  0x72,
  0x7E,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x72,
  0x72,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x7E,
  0x72,
  0x72,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x7E,
  0x66,
  0x66,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x7E,
  0x4E,
  0x4E,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x4E,
  0x4E,
  0x7E,
  0x3C,
  0x00,
};

//Turn eyes counterclockwise
byte eyeRotate2[][8] = {
  0x00,
  0x3C,
  0x72,
  0x72,
  0x7E,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x66,
  0x66,
  0x7E,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x4E,
  0x4E,
  0x7E,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x4E,
  0x4E,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x7E,
  0x4E,
  0x4E,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x7E,
  0x66,
  0x66,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x7E,
  0x72,
  0x72,
  0x3C,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x72,
  0x72,
  0x7E,
  0x3C,
  0x00,
};

//Blink eyes
byte eyeBlink[][8] = {
  0x00,
  0x00,
  0x3C,
  0x66,
  0x42,
  0x66,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x42,
  0x66,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x7E,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x42,
  0x66,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x3C,
  0x7E,
  0x7E,
  0x7E,
  0x3C,
  0x00,
};

//keep smile
byte eyeSmile[][8] = {
  0x00,
  0x00,
  0x18,
  0x24,
  0x42,
  0x00,
  0x00,
  0x00,
  0x00,
  0x18,
  0x24,
  0x42,
  0x00,
  0x00,
  0x00,
  0x00,
};

//cry-left
byte eyeCry1[][8] = {
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x18,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x18,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x18,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x18,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00,
};

//cry-right
byte eyeCry2[][8] = {
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x18,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x18,
  0x00,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x18,
  0x00,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x18,
  0x00,
  0x00,
  0x7E,
  0x3C,
  0x00,
  0x00,
  0x00,
  0x00,
};

//wheel-left
byte wheel_left[][8] = {
  0x18,
  0x10,
  0x10,
  0x9F,
  0xF9,
  0x08,
  0x08,
  0x18,
  0x20,
  0x42,
  0x25,
  0x18,
  0x18,
  0xA4,
  0x42,
  0x04,
  0x0C,
  0x08,
  0x88,
  0xF8,
  0x1F,
  0x11,
  0x10,
  0x30,
};

//wheel-right
byte wheel_right[][8] = {
  0x18,
  0x08,
  0x08,
  0xF9,
  0x9F,
  0x10,
  0x10,
  0x18,
  0x04,
  0x42,
  0xA4,
  0x18,
  0x18,
  0x25,
  0x42,
  0x20,
  0x30,
  0x10,
  0x11,
  0x1F,
  0xF8,
  0x88,
  0x08,
  0x0C,
};

//static emotion -left
byte static_emotion_left[][8] = {
  0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00, 0x07,
  0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x07,
  0x38, 0x44, 0x54, 0x54, 0x44, 0x38, 0x00, 0x03,
  0x00, 0x04, 0x04, 0x08, 0x30, 0x00, 0x03, 0x04,
  0x00, 0x10, 0x28, 0x28, 0x00, 0x00, 0x07, 0x04,
  0x00, 0x28, 0x10, 0x28, 0x00, 0x00, 0x00, 0x07,
  0x00, 0x00, 0x38, 0x28, 0x6C, 0x00, 0x04, 0x03,
  0x03, 0x07, 0x06, 0x00, 0x00, 0x01, 0x00, 0x01,
  0x01, 0x01, 0x39, 0x29, 0x39, 0x01, 0x00, 0x03,
  0x00, 0x0C, 0x7C, 0x0C, 0x00, 0x00, 0x03, 0x04,
  0x00, 0x60, 0x7C, 0x60, 0x00, 0x00, 0x03, 0x04,
  0x00, 0x00, 0x78, 0x00, 0x60, 0x60, 0x04, 0x03,
  0x00, 0x38, 0x28, 0x38, 0x00, 0x00, 0x03, 0x00,
  0x00, 0x00, 0x44, 0x38, 0x00, 0x00, 0x03, 0x02,
  0x00, 0x38, 0x44, 0x00, 0x38, 0x00, 0x03, 0x00,
  0x00, 0x71, 0x89, 0xA9, 0x89, 0x71, 0x02, 0x02,
  0x00, 0x3C, 0x42, 0x5A, 0x5A, 0x42, 0x3C, 0x01,
  0x38, 0x7C, 0x7C, 0x44, 0x38, 0x00, 0x03, 0x04,
  0x00, 0x30, 0x48, 0x49, 0x11, 0x20, 0x03, 0x01,
  0x1C, 0x22, 0x41, 0x4C, 0x20, 0x11, 0x08, 0x07,
  0x38, 0x44, 0x42, 0x12, 0x04, 0x18, 0x03, 0x02
};

//static emotion -right
byte static_emotion_right[][8] = {
  0x22, 0x14, 0x08, 0x14, 0x22, 0x00, 0x00, 0xE0,
  0x00, 0x1C, 0x1C, 0x1C, 0x00, 0x00, 0x20, 0xE0,
  0x1C, 0x22, 0x2A, 0x2A, 0x22, 0x1C, 0x00, 0xC0,
  0x00, 0x20, 0x20, 0x10, 0x0C, 0x00, 0xC0, 0x20,
  0x00, 0x08, 0x14, 0x14, 0x00, 0x00, 0xE0, 0x20,
  0x00, 0x1C, 0x14, 0x1C, 0x00, 0x20, 0x20, 0xC0,
  0x00, 0x00, 0x1C, 0x14, 0x36, 0x00, 0x20, 0xC0,
  0xC0, 0xE0, 0x60, 0x60, 0xC0, 0x80, 0x00, 0x80,
  0x80, 0x80, 0x9C, 0x94, 0x9C, 0x80, 0x00, 0xC0,
  0x00, 0x30, 0x3E, 0x30, 0x00, 0x00, 0xC0, 0x20,
  0x00, 0x06, 0x3E, 0x06, 0x00, 0x00, 0xC0, 0x20,
  0x00, 0x00, 0x1E, 0x00, 0x06, 0x06, 0x20, 0xC0,
  0x00, 0x1C, 0x14, 0x1C, 0x00, 0x40, 0xC0, 0x00,
  0x00, 0x00, 0x22, 0x1C, 0x00, 0x00, 0xC0, 0x40,
  0x00, 0x1C, 0x22, 0x00, 0x1C, 0x00, 0xC0, 0x00,
  0x00, 0x8E, 0x91, 0x95, 0x91, 0x8E, 0x40, 0x40,
  0x00, 0x3C, 0x42, 0x5A, 0x5A, 0x42, 0x3C, 0x80,
  0x1C, 0x3E, 0x3E, 0x22, 0x1C, 0x00, 0xC0, 0x20,
  0x00, 0x0C, 0x12, 0x92, 0x88, 0x04, 0xC0, 0x80,
  0x38, 0x44, 0x82, 0x32, 0x04, 0x88, 0x10, 0xE0,
  0x1C, 0x22, 0x42, 0x48, 0x20, 0x18, 0xC0, 0x40
};

//clear
byte clearEmotion[][8] = {
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
};

//rotate eyes
void eyesRotate(int delay_ms) {
  int count = sizeof(eyeRotate1) / sizeof(eyeRotate1[0]);
  emotion_time_next = millis();
  if (emotion_time_next - emotion_time_now >= delay_ms) {
    emotion_time_now = emotion_time_next;
    matrix.showStaticArray(eyeRotate1[emotion_count], eyeRotate2[emotion_count]);
    emotion_count++;
    if (emotion_count >= count)
      emotion_count = 0;
  }
}

//Blink eyes
void eyesBlink(int delay_ms) {
  emotion_time_next = millis();
  if (emotion_time_next - emotion_time_now >= delay_ms) {
    emotion_time_now = emotion_time_next;
    emotion_count++;
    if (emotion_count <= 10)
      matrix.showStaticArray(eyeBlink[0], eyeBlink[0]);
    else if (emotion_count > 10) {
      int count = sizeof(eyeBlink) / sizeof(eyeBlink[0]);
      matrix.showStaticArray(eyeBlink[(emotion_count - 11)], eyeBlink[(emotion_count - 11)]);
      if ((emotion_count - 10) >= count)
        emotion_count = 0;
    }
  }
}

//smile
void eyesSmile(int delay_ms) {
  int count = sizeof(eyeSmile) / sizeof(eyeSmile[0]);
  emotion_time_next = millis();
  if (emotion_time_next - emotion_time_now >= delay_ms) {
    emotion_time_now = emotion_time_next;
    matrix.showStaticArray(eyeSmile[emotion_count], eyeSmile[emotion_count]);
    emotion_count++;
    if (emotion_count >= count)
      emotion_count = 0;
  }
}

//cry
void eyesCry(int delay_ms) {
  int count = sizeof(eyeCry1) / sizeof(eyeCry1[0]);
  emotion_time_next = millis();
  if (emotion_time_next - emotion_time_now >= delay_ms) {
    emotion_time_now = emotion_time_next;
    matrix.showStaticArray(eyeCry1[emotion_count], eyeCry2[emotion_count]);
    emotion_count++;
    if (emotion_count >= count)
      emotion_count = 0;
  }
}

//wheel
void wheel(int mode, int delay_ms) {
  if (mode == 1) {
    emotion_time_next = millis();
    if (emotion_time_next - emotion_time_now >= delay_ms) {
      emotion_time_now = emotion_time_next;
      int count = sizeof(wheel_left) / sizeof(wheel_left[0]);
      matrix.showStaticArray(wheel_left[emotion_count], wheel_left[emotion_count]);
      emotion_count++;
      if (emotion_count >= count)
        emotion_count = 0;
    }
  }
  if (mode == 2) {

    emotion_time_next = millis();
    if (emotion_time_next - emotion_time_now >= delay_ms) {
      emotion_time_now = emotion_time_next;
      int count = sizeof(wheel_right) / sizeof(wheel_right[0]);
      matrix.showStaticArray(wheel_right[emotion_count], wheel_right[emotion_count]);
      emotion_count++;
      if (emotion_count >= count)
        emotion_count = 0;
    }
  }
}

//show static emotion
void staticEmtions(int emotion) {
  int count = sizeof(static_emotion_left) / sizeof(static_emotion_left[0]);
  emotion = constrain(emotion, 0, count - 1);
  matrix.showStaticArray(static_emotion_left[emotion], static_emotion_right[emotion]);
}

//clear all
void clearEmtions(void) {
  emotion_time_next = millis();
  if (emotion_time_next - emotion_time_now >= 500) {
    emotion_time_now = emotion_time_next;
    emotion_count = 0;
    int count = sizeof(clearEmotion) / sizeof(clearEmotion[0]);
    for (int i = 0; i < count; i++)
      matrix.showStaticArray(clearEmotion[i], clearEmotion[i]);
  }
}

//initialize HT16K33
void Emotion_Setup(int address) {
  matrix.init(address);
  matrix.setBrightness(255);
  emotion_time_now = millis();
}

int emotion_task_mode = 0;
//Emotion show
void Emotion_Show(int mode) {
  if (mode == 0)
    clearEmtions();
  else if (mode == 1)
    eyesRotate(150);
  else if (mode == 2)
    eyesCry(200);
  else if (mode == 3)
    eyesSmile(200);
  else if (mode == 4)  //right
    wheel(1, 100);
  else if (mode == 5)  //left
    wheel(2, 100);
  else if (mode == 6)
    eyesBlink(100);
  // else if (mode == 7)
  //   staticEmtions(emotion_flag);
}

extern int Check_Module_value;
//Emotion set mode
void Emotion_SetMode(int mode) {
  if (Check_Module_value == MATRIX_IS_EXIST) {
    if (mode <= 6) {
      clearEmtions();
      emotion_task_mode = mode;
    } else if (mode >= 7) {
      emotion_task_mode = 7;
      emotion_flag = millis() % 22;
      Serial.println("emotion_flag:" + String(emotion_flag));
      staticEmtions(emotion_flag);
    }
  }
}
